/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.oven_fan;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.forsteri.ratatouille.content.oven_fan.OvenFanBlock;
import org.jetbrains.annotations.Nullable;

public class OvenFanBlockEntity
extends KineticBlockEntity
implements IAirCurrentSource {
    public AirCurrent airCurrent = new AirCurrent((IAirCurrentSource)this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;

    public OvenFanBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.level;
    }

    public BlockPos getAirCurrentPos() {
        return this.worldPosition;
    }

    public Direction getAirflowOriginSide() {
        return (Direction)this.getBlockState().getValue(OvenFanBlock.HORIZONTAL_FACING);
    }

    @Nullable
    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return (speed = OvenFanBlockEntity.convertToDirection((float)speed, (Direction)facing)) > 0.0f ? facing : facing.getOpposite();
    }

    public boolean isSourceRemoved() {
        return this.remove;
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public void tick() {
        boolean server;
        super.tick();
        if (this.level == null) {
            return;
        }
        boolean bl = server = !this.level.isClientSide || this.isVirtual();
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.sendData();
        }
        if (this.getSpeed() != 0.0f) {
            if (this.entitySearchCooldown-- <= 0) {
                this.entitySearchCooldown = 5;
                this.airCurrent.findEntities();
            }
            this.airCurrent.tick();
        }
    }

    public float calculateStressApplied() {
        return 2.0f;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }
}

