/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.data.recipe;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.forsteri.ratatouille.Ratatouille;
import org.forsteri.ratatouille.entry.CRBlocks;
import org.forsteri.ratatouille.entry.CRFluids;
import org.forsteri.ratatouille.entry.CRItems;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;

public final class RatatouilleStandardRecipeGen
extends BaseRecipeProvider {
    final List<BaseRecipeProvider.GeneratedRecipe> all = new ArrayList<BaseRecipeProvider.GeneratedRecipe>();
    BaseRecipeProvider.GeneratedRecipe CHEF_HAT = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRItems.CHEF_HAT).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((Item)Items.WHITE_WOOL).asItem())).viaShaped(b -> b.pattern(" Y ").pattern(" X ").define(Character.valueOf('Y'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('X'), CommonTags.TOOLS_KNIFE));
    BaseRecipeProvider.GeneratedRecipe CHEF_HAT_WITH_GOGGLES = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRItems.CHEF_HAT_WITH_GOGGLES).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> CRItems.CHEF_HAT.get())).viaShapeless(b -> b.requires((ItemLike)CRItems.CHEF_HAT.get()).requires((ItemLike)AllItems.GOGGLES.get()));
    BaseRecipeProvider.GeneratedRecipe COMPOST_TEA_BOTTLE = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRItems.COMPOST_TEA_BOTTLE).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)CRFluids.COMPOST_TEA.getBucket()::get)).viaShapeless(b -> b.requires((ItemLike)CRFluids.COMPOST_TEA.getBucket().get()).requires((ItemLike)Items.GLASS_BOTTLE, 8));
    BaseRecipeProvider.GeneratedRecipe COMPOST_TOWER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.COMPOST_TOWER_BLOCK).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((Item)Items.BARREL).asItem())).viaShaped(b -> b.pattern(" Y ").pattern(" X ").pattern(" Y ").define(Character.valueOf('Y'), (ItemLike)AllItems.ZINC_INGOT.get()).define(Character.valueOf('X'), (ItemLike)Items.BARREL));
    BaseRecipeProvider.GeneratedRecipe EGG_SHELL_TO_BONE_MEAL = this.create((com.google.common.base.Supplier<ItemLike>)((com.google.common.base.Supplier)() -> ((Item)Items.BONE_MEAL).asItem())).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((Item)Items.EGG).asItem())).viaShapeless(b -> b.requires((ItemLike)CRItems.EGG_SHELL.get()));
    BaseRecipeProvider.GeneratedRecipe FROZEN_BLOCK = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.FROZEN_BLOCK).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((Item)Items.BLUE_ICE).asItem())).viaShaped(b -> b.pattern(" Y ").pattern("YXY").pattern(" Y ").define(Character.valueOf('Y'), (ItemLike)Items.BLUE_ICE).define(Character.valueOf('X'), (ItemLike)Items.POWDER_SNOW_BUCKET));
    BaseRecipeProvider.GeneratedRecipe IRRIGATION_TOWER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.IRRIGATION_TOWER_BLOCK).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((BlockEntry)AllBlocks.FLUID_TANK).asItem())).viaShaped(b -> b.pattern(" Z ").pattern("YXY").define(Character.valueOf('X'), (ItemLike)AllBlocks.FLUID_PIPE).define(Character.valueOf('Y'), (ItemLike)AllItems.COPPER_SHEET).define(Character.valueOf('Z'), (ItemLike)AllBlocks.FLUID_TANK));
    BaseRecipeProvider.GeneratedRecipe MECHANICAL_DEMOLDER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.MECHANICAL_DEMOLDER).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((BlockEntry)AllBlocks.ANDESITE_CASING).asItem())).viaShaped(b -> b.pattern(" Z ").pattern(" Y ").pattern(" X ").define(Character.valueOf('Z'), (ItemLike)AllItems.ANDESITE_ALLOY).define(Character.valueOf('Y'), (ItemLike)AllBlocks.ANDESITE_CASING).define(Character.valueOf('X'), (ItemLike)Items.SLIME_BALL));
    BaseRecipeProvider.GeneratedRecipe ORGANIC_COMPOST = this.create((com.google.common.base.Supplier<ItemLike>)((com.google.common.base.Supplier)((Supplier)ModItems.ORGANIC_COMPOST)::get)).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> CRItems.COMPOST_RESIDUE.asItem())).viaShaped(b -> b.pattern(" Y ").pattern("YXY").pattern(" Y ").define(Character.valueOf('Y'), CRItems.COMPOST_RESIDUE).define(Character.valueOf('X'), (ItemLike)Items.DIRT));
    BaseRecipeProvider.GeneratedRecipe OVEN = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.OVEN).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((ItemEntry)AllItems.ANDESITE_ALLOY).asItem())).viaShaped(b -> b.pattern(" Y ").pattern(" X ").pattern(" Y ").define(Character.valueOf('Y'), (ItemLike)AllItems.ANDESITE_ALLOY).define(Character.valueOf('X'), (ItemLike)Items.BARREL));
    BaseRecipeProvider.GeneratedRecipe OVEN_FAN = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.OVEN_FAN).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((BlockEntry)AllBlocks.ANDESITE_CASING).asItem())).viaShaped(b -> b.pattern(" Y ").pattern(" X ").pattern(" Z ").define(Character.valueOf('Y'), (ItemLike)AllBlocks.COGWHEEL).define(Character.valueOf('X'), (ItemLike)AllBlocks.ANDESITE_CASING).define(Character.valueOf('Z'), (ItemLike)AllItems.PROPELLER));
    BaseRecipeProvider.GeneratedRecipe SPREADER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.SPREADER_BLOCK).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((ItemEntry)AllItems.ANDESITE_ALLOY).asItem())).viaShaped(b -> b.pattern(" X ").pattern("ZSZ").pattern(" Y ").define(Character.valueOf('Y'), (ItemLike)AllItems.PROPELLER).define(Character.valueOf('S'), (ItemLike)AllBlocks.ANDESITE_CASING).define(Character.valueOf('Z'), (ItemLike)AllItems.TREE_FERTILIZER).define(Character.valueOf('X'), (ItemLike)AllBlocks.COGWHEEL));
    BaseRecipeProvider.GeneratedRecipe SQUEEZE_BASIN = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.SQUEEZE_BASIN).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((Item)Items.COPPER_INGOT).asItem())).viaShaped(b -> b.pattern(" Z ").pattern("Y Y").pattern("YYY").define(Character.valueOf('Y'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('Z'), (ItemLike)AllItems.COPPER_SHEET));
    BaseRecipeProvider.GeneratedRecipe THRESHER = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)CRBlocks.THRESHER).unlockedBy((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> ((ItemEntry)AllItems.ANDESITE_ALLOY).asItem())).viaShaped(b -> b.pattern(" S ").pattern("ZXZ").pattern(" Y ").define(Character.valueOf('Y'), (ItemLike)AllBlocks.ANDESITE_CASING).define(Character.valueOf('Z'), (ItemLike)AllBlocks.SHAFT).define(Character.valueOf('S'), (ItemLike)AllItems.ANDESITE_ALLOY).define(Character.valueOf('X'), (ItemLike)AllBlocks.MECHANICAL_HARVESTER));
    BaseRecipeProvider.GeneratedRecipe CAKE_MOLD_BAKED = this.create((com.google.common.base.Supplier<ItemLike>)((com.google.common.base.Supplier)() -> CRItems.CAKE_MOLD_BAKED.get())).viaCooking((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> CRItems.CAKE_MOLD_FILLED.get())).forDuration(200).inSmoker();
    BaseRecipeProvider.GeneratedRecipe ROAST_COCO = this.create((com.google.common.base.Supplier<ItemLike>)((com.google.common.base.Supplier)() -> CRItems.DRIED_COCOA_BEANS.get())).viaCooking((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> Items.COCOA_BEANS)).forDuration(20).inSmoker();
    BaseRecipeProvider.GeneratedRecipe SAUSAGE = this.create((com.google.common.base.Supplier<ItemLike>)((com.google.common.base.Supplier)() -> CRItems.SAUSAGE.get())).viaCooking((com.google.common.base.Supplier<? extends ItemLike>)((com.google.common.base.Supplier)() -> CRItems.RAW_SAUSAGE.get())).forDuration(100).inSmoker();

    public RatatouilleStandardRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "ratatouille");
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((com.google.common.base.Supplier<ItemLike>)((com.google.common.base.Supplier)() -> result.get()));
    }

    GeneratedRecipeBuilder create(com.google.common.base.Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(result);
    }

    @NotNull
    public String getName() {
        return "Create: Ratatouille's Standard Recipes";
    }

    class GeneratedRecipeBuilder {
        List<ICondition> recipeConditions = new ArrayList<ICondition>();
        private String suffix = "";
        private com.google.common.base.Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private com.google.common.base.Supplier<ItemPredicate> unlockedBy;
        private int amount = 1;

        public GeneratedRecipeBuilder(com.google.common.base.Supplier<? extends ItemLike> result) {
            this();
            this.result = result;
        }

        private GeneratedRecipeBuilder() {
        }

        public GeneratedRecipeBuilder(ResourceLocation result) {
            this();
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return RatatouilleStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RatatouilleStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createLocation(String recipeType) {
            return Ratatouille.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()) : this.compatDatagenOutput;
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return RatatouilleStandardRecipeGen.this.register(recipeOutput -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RatatouilleStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                RecipeOutput conditionalOutput = recipeOutput.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                b.save(conditionalOutput, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaNetheriteSmithing(com.google.common.base.Supplier<? extends Item> base, com.google.common.base.Supplier<Ingredient> upgradeMaterial) {
            return RatatouilleStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).asItem());
                b.unlocks("has_item", RatatouilleStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)base.get()}).build()}));
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return Ratatouille.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        GeneratedCookingRecipeBuilder viaCooking(com.google.common.base.Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((com.google.common.base.Supplier<Ingredient>)((com.google.common.base.Supplier)() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(com.google.common.base.Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        GeneratedRecipeBuilder unlockedBy(com.google.common.base.Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedCookingRecipeBuilder viaCookingTag(com.google.common.base.Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((com.google.common.base.Supplier<Ingredient>)((com.google.common.base.Supplier)() -> Ingredient.of((TagKey)((TagKey)tag.get()))));
        }

        GeneratedRecipeBuilder unlockedByTag(com.google.common.base.Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        class GeneratedCookingRecipeBuilder {
            private com.google.common.base.Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;

            GeneratedCookingRecipeBuilder(com.google.common.base.Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            private <T extends AbstractCookingRecipe> BaseRecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return RatatouilleStandardRecipeGen.this.register(recipeOutput -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.DIRT : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", RatatouilleStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    RecipeOutput conditionalOutput = recipeOutput.withConditions(GeneratedRecipeBuilder.this.recipeConditions.toArray(new ICondition[0]));
                    b.save(conditionalOutput, GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }
        }
    }
}

