/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.ponder;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlock;
import org.forsteri.ratatouille.entry.CRFluids;
import org.forsteri.ratatouille.entry.CRItems;
import vectorwing.farmersdelight.common.registry.ModItems;

public class SqueezeBasinScene {
    public static void squeezeBasin(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("squeeze_basin", "Process Items Efficiently Using the Squeeze Basin");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().fromTo(0, 0, 0, 4, 0, 4), Direction.UP);
        scene.idle(5);
        BlockPos squeezeBasinPos = util.grid().at(3, 2, 2);
        scene.world().showSection(util.select().fromTo(3, 1, 2, 3, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(squeezeBasinPos), Direction.DOWN);
        scene.overlay().showText(50).text("Squeeze basins handle squeezing and filling tasks").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(squeezeBasinPos));
        scene.idle(60);
        BlockPos pressPos = squeezeBasinPos.above(2);
        scene.world().showSection(util.select().position(pressPos), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 4, 3, 3, 4, 4), Direction.NORTH);
        scene.world().showSection(util.select().fromTo(3, 0, 5, 3, 4, 5), Direction.NORTH);
        scene.idle(5);
        BlockPos inputDepotPos = util.grid().at(3, 1, 1);
        BlockPos inputFunnelPos = util.grid().at(3, 2, 1);
        BlockPos outputDepotPos = util.grid().at(2, 1, 2);
        scene.world().modifyBlockEntity(inputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(CRItems.SALTY_DOUGH.asStack())));
        scene.world().showSection(util.select().fromTo(inputDepotPos, inputFunnelPos), Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(outputDepotPos), Direction.EAST);
        scene.idle(5);
        scene.overlay().showText(50).text("Output products typically emerge from the side with a port").placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(outputDepotPos));
        scene.idle(10);
        scene.world().modifyBlockEntity(inputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(ItemStack.EMPTY)));
        scene.world().flapFunnel(inputFunnelPos, false);
        scene.world().modifyBlockEntity(pressPos, MechanicalPressBlockEntity.class, MechanicalPressBlockEntity::startProcessingBasin);
        scene.idle(30);
        scene.world().modifyBlockEntity(outputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(new ItemStack((ItemLike)ModItems.RAW_PASTA.get()))));
        scene.idle(45);
        scene.world().hideSection(util.select().fromTo(inputDepotPos, inputFunnelPos), Direction.NORTH);
        scene.world().modifyBlockEntity(outputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(ItemStack.EMPTY)));
        scene.idle(5);
        BlockPos mixerPos = util.grid().at(5, 2, 1);
        BlockPos basinPos = util.grid().at(5, 0, 1);
        scene.world().showSection(util.select().fromTo(basinPos, mixerPos), Direction.WEST);
        scene.idle(5);
        BlockPos pumpPos = util.grid().at(4, 2, 2);
        scene.world().createItemOnBeltLike(basinPos, Direction.UP, new ItemStack((ItemLike)Items.CHICKEN, 64));
        scene.world().createItemOnBeltLike(basinPos, Direction.UP, new ItemStack((ItemLike)CRItems.SALT.get(), 64));
        scene.world().showSection(util.select().fromTo(5, 0, 2, 5, 2, 2), Direction.WEST);
        scene.world().showSection(util.select().position(pumpPos), Direction.WEST);
        scene.idle(5);
        scene.overlay().showText(50).text("Squeeze basin also accept fluid").placeNearTarget().attachKeyFrame().pointAt(util.vector().centerOf(pumpPos));
        scene.world().modifyBlockEntityNBT(util.select().position(basinPos), BasinBlockEntity.class, nbt -> nbt.put("VisualizedFluids", (Tag)NBTHelper.writeCompoundList((Iterable)ImmutableList.of((Object)IntAttached.with((int)1, (Object)new FluidStack((Fluid)CRFluids.MINCE_MEAT.get(), 1000))), ia -> (CompoundTag)((FluidStack)ia.getValue()).save(scene.world().getHolderLookupProvider()))));
        scene.world().modifyBlock(squeezeBasinPos, s -> (BlockState)s.setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(true)), false);
        scene.world().modifyBlockEntity(mixerPos, MechanicalMixerBlockEntity.class, MechanicalMixerBlockEntity::startProcessingBasin);
        scene.idle(80);
        scene.world().modifyBlockEntity(pressPos, MechanicalPressBlockEntity.class, MechanicalPressBlockEntity::startProcessingBasin);
        scene.idle(30);
        scene.world().modifyBlock(squeezeBasinPos, s -> (BlockState)s.setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(false)), false);
        scene.world().modifyBlockEntity(outputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(CRItems.RAW_SAUSAGE.asStack())));
        scene.idle(40);
        scene.overlay().showText(40).text("For specific recipes, consider filling the output port with items").placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(squeezeBasinPos, Direction.WEST));
        scene.idle(50);
        scene.overlay().showControls(util.vector().blockSurface(squeezeBasinPos, Direction.WEST), Pointing.DOWN, 30).withItem(CRItems.SAUSAGE_CASING.asStack()).rightClick();
        scene.world().modifyBlockEntity(outputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(CRItems.RAW_SAUSAGE.asStack())));
        scene.idle(40);
        scene.world().modifyBlock(squeezeBasinPos, s -> (BlockState)s.setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(40);
        scene.world().modifyBlockEntity(outputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(ItemStack.EMPTY)));
        scene.world().modifyBlock(squeezeBasinPos, s -> (BlockState)s.setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(false)), false);
        BlockPos deployerPos = util.grid().at(1, 2, 2);
        scene.world().modifyBlockEntityNBT(util.select().position(deployerPos), DeployerBlockEntity.class, nbt -> nbt.put("HeldItem", CRItems.SAUSAGE_CASING.asStack().saveOptional(scene.world().getHolderLookupProvider())));
        scene.world().showSection(util.select().position(deployerPos), Direction.EAST);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 2, 3, 1, 2, 4), Direction.NORTH);
        scene.world().showSection(util.select().fromTo(1, 0, 5, 1, 2, 5), Direction.NORTH);
        scene.idle(5);
        scene.overlay().showText(40).text("Deployers can improve efficiency").placeNearTarget().attachKeyFrame().pointAt(util.vector().centerOf(deployerPos));
        scene.idle(50);
        scene.world().moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world().modifyBlock(squeezeBasinPos, s -> (BlockState)s.setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(true)), false);
        scene.world().moveDeployer(deployerPos, -1.0f, 25);
        scene.world().modifyBlockEntity(pressPos, MechanicalPressBlockEntity.class, MechanicalPressBlockEntity::startProcessingBasin);
        scene.idle(30);
        scene.world().modifyBlockEntity(outputDepotPos, DepotBlockEntity.class, be -> ((DepotBehaviour)be.getBehaviour(DepotBehaviour.TYPE)).setHeldItem(new TransportedItemStack(CRItems.SAUSAGE.asStack())));
        scene.world().modifyBlock(squeezeBasinPos, s -> (BlockState)s.setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(false)), false);
    }
}

