/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector4f;

public class Camera {
    final Vector3d pos = new Vector3d();
    final BlockPos blockPos = new BlockPos();
    float pitch;
    float yaw;
    EntityLivingBase entity;
    boolean thirdPerson;
    final float partialTicks;

    public Camera(EntityLivingBase entity, float partialTicks) {
        this.partialTicks = partialTicks;
        Vector4f offset = new Vector4f();
        Matrix4f inverseModelView = new Matrix4f((Matrix4fc)RenderingState.INSTANCE.getModelViewMatrix()).invert();
        inverseModelView.transform(offset);
        double camX = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)partialTicks + (double)offset.x;
        double camY = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)partialTicks + (double)offset.y;
        double camZ = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)partialTicks + (double)offset.z;
        this.entity = entity;
        this.pos.set(camX, camY, camZ);
        this.blockPos.set(MathHelper.floor_double((double)camX), MathHelper.floor_double((double)camY), MathHelper.floor_double((double)camZ));
        this.pitch = entity.cameraPitch;
        this.yaw = entity.rotationYaw;
        this.thirdPerson = Minecraft.getMinecraft().gameSettings.thirdPersonView == 1;
    }

    @Generated
    public Vector3d getPos() {
        return this.pos;
    }

    @Generated
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public EntityLivingBase getEntity() {
        return this.entity;
    }

    @Generated
    public boolean isThirdPerson() {
        return this.thirdPerson;
    }

    @Generated
    public float getPartialTicks() {
        return this.partialTicks;
    }
}

