/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.states;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.stacks.BooleanStateStack;
import com.gtnewhorizons.angelica.glsm.stacks.TextureBindingStack;
import lombok.Generated;
import org.joml.Matrix4fStack;

public class TextureUnitArray {
    private final TextureBindingStack[] bindings = new TextureBindingStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] states = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] texture1DStates = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] texture3DStates = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] texGenSStates = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] texGenTStates = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] texGenRStates = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    private final BooleanStateStack[] texGenQStates = new BooleanStateStack[GLStateManager.MAX_TEXTURE_UNITS];
    public final Matrix4fStack[] textureMatricies = new Matrix4fStack[GLStateManager.MAX_TEXTURE_UNITS];

    public TextureUnitArray() {
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            this.bindings[i] = new TextureBindingStack();
            this.states[i] = new BooleanStateStack(3553);
            this.texture1DStates[i] = new BooleanStateStack(3552);
            this.texture3DStates[i] = new BooleanStateStack(32879);
            this.texGenSStates[i] = new BooleanStateStack(3168);
            this.texGenTStates[i] = new BooleanStateStack(3169);
            this.texGenRStates[i] = new BooleanStateStack(3170);
            this.texGenQStates[i] = new BooleanStateStack(3171);
            this.textureMatricies[i] = new Matrix4fStack(GLStateManager.MAX_TEXTURE_STACK_DEPTH);
        }
    }

    public TextureBindingStack getTextureUnitBindings(int index) {
        return this.bindings[index];
    }

    public BooleanStateStack getTextureUnitStates(int index) {
        return this.states[index];
    }

    public BooleanStateStack getTexture1DStates(int index) {
        return this.texture1DStates[index];
    }

    public BooleanStateStack getTexture3DStates(int index) {
        return this.texture3DStates[index];
    }

    public BooleanStateStack getTexGenSStates(int index) {
        return this.texGenSStates[index];
    }

    public BooleanStateStack getTexGenTStates(int index) {
        return this.texGenTStates[index];
    }

    public BooleanStateStack getTexGenRStates(int index) {
        return this.texGenRStates[index];
    }

    public BooleanStateStack getTexGenQStates(int index) {
        return this.texGenQStates[index];
    }

    public Matrix4fStack getTextureUnitMatrix(int index) {
        return this.textureMatricies[index];
    }

    public boolean equals(Object state) {
        if (this == state) {
            return true;
        }
        if (!(state instanceof TextureUnitArray)) {
            return false;
        }
        TextureUnitArray textureUnitArray = (TextureUnitArray)state;
        for (int i = 0; i < GLStateManager.MAX_TEXTURE_UNITS; ++i) {
            if (!this.bindings[i].sameAs(textureUnitArray.bindings[i])) {
                return false;
            }
            if (!this.states[i].sameAs(textureUnitArray.states[i])) {
                return false;
            }
            if (!this.texture1DStates[i].sameAs(textureUnitArray.texture1DStates[i])) {
                return false;
            }
            if (!this.texture3DStates[i].sameAs(textureUnitArray.texture3DStates[i])) {
                return false;
            }
            if (!this.texGenSStates[i].sameAs(textureUnitArray.texGenSStates[i])) {
                return false;
            }
            if (!this.texGenTStates[i].sameAs(textureUnitArray.texGenTStates[i])) {
                return false;
            }
            if (!this.texGenRStates[i].sameAs(textureUnitArray.texGenRStates[i])) {
                return false;
            }
            if (this.texGenQStates[i].sameAs(textureUnitArray.texGenQStates[i])) continue;
            return false;
        }
        return true;
    }

    @Generated
    public Matrix4fStack[] getTextureMatricies() {
        return this.textureMatricies;
    }
}

