/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jss.notfine.config.MCPatcherForgeConfig;
import jss.notfine.util.FontRendererExpansion;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;

public class FontUtils {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.EXTENDED_HD);
    private static final boolean enable = MCPatcherForgeConfig.ExtendedHD.hdFont;
    private static final boolean enableNonHD = MCPatcherForgeConfig.ExtendedHD.nonHDFontWidth;
    private static final int ROWS = 16;
    private static final int COLS = 16;
    public static final char[] AVERAGE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123467890".toCharArray();
    public static final int[] SPACERS = new int[]{33721342, 0x2808080, 0xDFFFFFF};
    private static final boolean showLines = false;
    private static final Set<FontRenderer> allRenderers = new HashSet<FontRenderer>();

    public static void init() {
    }

    public static ResourceLocation getFontName(FontRenderer fontRenderer, ResourceLocation font, float hdFontAdj) {
        ResourceLocation newFont;
        FontRendererExpansion expansion = (FontRendererExpansion)fontRenderer;
        if (expansion.getDefaultFont() == null) {
            expansion.setDefaultFont(font);
        }
        ResourceLocation defaultFont = expansion.getDefaultFont();
        if (expansion.getHDFont() == null) {
            String namespace = defaultFont.getResourceDomain();
            String name = defaultFont.getResourcePath().replaceAll(".*/", "");
            expansion.setHDFont(new ResourceLocation(namespace, "mcpatcher/font/" + name));
        }
        ResourceLocation hdFont = expansion.getHDFont();
        if (enable && TexturePackAPI.hasResource(hdFont)) {
            if (!hdFont.equals((Object)defaultFont)) {
                logger.fine("using %s instead of %s", hdFont, defaultFont);
            }
            expansion.setIsHD(true);
            newFont = hdFont;
        } else {
            logger.fine("using default %s", defaultFont);
            expansion.setIsHD(enable && enableNonHD);
            newFont = defaultFont;
        }
        expansion.setFontAdj(expansion.getIsHD() ? hdFontAdj : 1.0f);
        return newFont;
    }

    public static float[] computeCharWidthsf(FontRenderer fontRenderer, ResourceLocation filename, BufferedImage image, int[] rgb, int[] charWidth) {
        int ch;
        float[] charWidthf = new float[charWidth.length];
        if (!((FontRendererExpansion)fontRenderer).getIsHD()) {
            for (int i = 0; i < charWidth.length; ++i) {
                charWidthf[i] = charWidth[i];
            }
            charWidthf[32] = 4.0f;
            return charWidthf;
        }
        allRenderers.add(fontRenderer);
        int width = image.getWidth();
        int height = image.getHeight();
        int colWidth = width / 16;
        int rowHeight = height / 16;
        block3: for (ch = 0; ch < charWidth.length; ++ch) {
            int row = ch / 16;
            int col = ch % 16;
            for (int colIdx = colWidth - 1; colIdx >= 0; --colIdx) {
                int x = col * colWidth + colIdx;
                for (int rowIdx = 0; rowIdx < rowHeight; ++rowIdx) {
                    int y = row * rowHeight + rowIdx;
                    int pixel = rgb[x + y * width];
                    if (!FontUtils.isOpaque(pixel)) continue;
                    if (FontUtils.printThis(ch)) {
                        logger.finer("%d '%c' pixel (%d, %d) = %08x, colIdx = %d", ch, Character.valueOf((char)ch), x, y, pixel, colIdx);
                    }
                    charWidthf[ch] = 128.0f * (float)(colIdx + 1) / (float)width + 1.0f;
                    continue block3;
                }
            }
        }
        for (ch = 0; ch < charWidthf.length; ++ch) {
            if (charWidthf[ch] <= 0.0f) {
                charWidthf[ch] = 2.0f;
                continue;
            }
            if (!(charWidthf[ch] >= 7.99f)) continue;
            charWidthf[ch] = 7.99f;
        }
        boolean[] isOverride = new boolean[charWidth.length];
        try {
            FontUtils.getCharWidthOverrides(filename, charWidthf, isOverride);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!isOverride[32]) {
            charWidthf[32] = FontUtils.defaultSpaceWidth(charWidthf);
        }
        for (int ch2 = 0; ch2 < charWidth.length; ++ch2) {
            charWidth[ch2] = Math.round(charWidthf[ch2]);
            if (!FontUtils.printThis(ch2)) continue;
            logger.finer("charWidth[%d '%c'] = %f", ch2, Character.valueOf((char)ch2), Float.valueOf(charWidthf[ch2]));
        }
        return charWidthf;
    }

    private static float getCharWidthf(FontRenderer fontRenderer, char ch) {
        float width = fontRenderer.getCharWidth(ch);
        if (width < 0.0f || ((FontRendererExpansion)fontRenderer).getCharWidthf() == null || ch >= ((FontRendererExpansion)fontRenderer).getCharWidthf().length) {
            return width;
        }
        return ((FontRendererExpansion)fontRenderer).getCharWidthf()[ch];
    }

    public static float getCharWidthf(FontRenderer fontRenderer, int[] charWidth, int ch) {
        return ((FontRendererExpansion)fontRenderer).getIsHD() ? ((FontRendererExpansion)fontRenderer).getCharWidthf()[ch] * (float)fontRenderer.FONT_HEIGHT / 8.0f : (float)charWidth[ch];
    }

    public static float getStringWidthf(FontRenderer fontRenderer, String s) {
        float totalWidth = 0.0f;
        if (s != null) {
            boolean isLink = false;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                float cWidth = FontUtils.getCharWidthf(fontRenderer, c);
                if (cWidth < 0.0f && i < s.length() - 1) {
                    if ((c = s.charAt(++i)) == 'l' || c == 'L') {
                        isLink = true;
                    } else if (c == 'r' || c == 'R') {
                        isLink = false;
                    }
                    cWidth = 0.0f;
                }
                totalWidth += cWidth;
                if (!isLink) continue;
                totalWidth += 1.0f;
            }
        }
        return totalWidth;
    }

    public static ResourceLocation getUnicodePage(ResourceLocation resource) {
        ResourceLocation newResource;
        if (enable && resource != null && !(newResource = new ResourceLocation(resource.getResourceDomain(), resource.getResourcePath().replaceFirst("^textures/", "mcpatcher/"))).equals((Object)resource) && TexturePackAPI.hasResource(newResource)) {
            logger.fine("using %s instead of %s", newResource, resource);
            return newResource;
        }
        return resource;
    }

    private static boolean isOpaque(int pixel) {
        for (int i : SPACERS) {
            if (pixel != i) continue;
            return false;
        }
        return (pixel >> 24 & 0xF0) > 0;
    }

    private static boolean printThis(int ch) {
        return "ABCDEF abcdef0123456789".indexOf(ch) >= 0;
    }

    private static float defaultSpaceWidth(float[] charWidthf) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            return 4.0f;
        }
        float sum = 0.0f;
        int n = 0;
        for (char ch : AVERAGE_CHARS) {
            if (!(charWidthf[ch] > 0.0f)) continue;
            sum += charWidthf[ch];
            ++n;
        }
        if (n > 0) {
            return sum / (float)n * 7.0f / 12.0f;
        }
        return 4.0f;
    }

    private static void getCharWidthOverrides(ResourceLocation font, float[] charWidthf, boolean[] isOverride) {
        ResourceLocation textFile = TexturePackAPI.transformResourceLocation(font, ".png", ".properties");
        PropertiesFile props = PropertiesFile.get(logger, textFile);
        if (props == null) {
            return;
        }
        logger.fine("reading character widths from %s", textFile);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String key = entry.getKey().trim();
            String value = entry.getValue().trim();
            if (!key.matches("^width\\.\\d+$") || value.isEmpty()) continue;
            try {
                int ch = Integer.parseInt(key.substring(6));
                float width = Float.parseFloat(value);
                if (ch < 0 || ch >= charWidthf.length) continue;
                logger.finer("setting charWidthf[%d '%c'] to %f", ch, Character.valueOf((char)ch), Float.valueOf(width));
                charWidthf[ch] = width;
                isOverride[ch] = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("HD Font", 1){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
            }

            @Override
            public void afterChange() {
                for (FontRenderer renderer : allRenderers) {
                    renderer.readFontTexture();
                }
            }
        });
    }
}

