/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.ResourceLocationWithSource;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jss.notfine.util.AbstractTextureExpansion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class TexturePackAPI {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.TEXTURE_PACK);
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String MCPATCHER_SUBDIR = "mcpatcher/";
    public static final ResourceLocation ITEMS_PNG = new ResourceLocation("textures/atlas/items.png");
    private static final String ASSETS = "assets/";

    public static List<IResourcePack> getResourcePacks(String namespace) {
        ArrayList<IResourcePack> resourcePacks = new ArrayList<IResourcePack>();
        IResourceManager resourceManager = Minecraft.getMinecraft().getResourceManager();
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            Set entrySet = ((SimpleReloadableResourceManager)resourceManager).domainResourceManagers.entrySet();
            for (Map.Entry entry : entrySet) {
                List packs;
                if (namespace != null && !namespace.equals(entry.getKey()) || (packs = ((FallbackResourceManager)entry.getValue()).resourcePacks) == null) continue;
                resourcePacks.removeAll(packs);
                resourcePacks.addAll(packs);
            }
        }
        return resourcePacks;
    }

    public static Set<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(DEFAULT_NAMESPACE);
        IResourceManager resourceManager = Minecraft.getMinecraft().getResourceManager();
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager simpleReloadableResourceManager = (SimpleReloadableResourceManager)resourceManager;
            namespaces.addAll(simpleReloadableResourceManager.domainResourceManagers.keySet());
        }
        return namespaces;
    }

    public static boolean isDefaultTexturePack() {
        return TexturePackAPI.getResourcePacks(DEFAULT_NAMESPACE).size() <= 1;
    }

    public static InputStream getInputStream(ResourceLocation resource) {
        try {
            if (resource instanceof ResourceLocationWithSource) {
                ResourceLocationWithSource resourceLocationWithSource = (ResourceLocationWithSource)resource;
                try {
                    return resourceLocationWithSource.getSource().getInputStream(resource);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return resource == null ? null : Minecraft.getMinecraft().getResourceManager().getResource(resource).getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean hasResource(ResourceLocation resource) {
        if (resource == null) {
            return false;
        }
        if (resource.getResourcePath().endsWith(".png")) {
            return TexturePackAPI.getImage(resource) != null;
        }
        if (resource.getResourcePath().endsWith(".properties")) {
            return TexturePackAPI.getProperties(resource) != null;
        }
        InputStream is = TexturePackAPI.getInputStream(resource);
        MCPatcherUtils.close(is);
        return is != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasCustomResource(ResourceLocation resource) {
        boolean bl;
        InputStream pack;
        InputStream jar;
        block8: {
            boolean bl2;
            block7: {
                jar = null;
                pack = null;
                try {
                    pack = TexturePackAPI.getInputStream(resource);
                    jar = Minecraft.getMinecraft().mcDefaultResourcePack.getInputStream(resource);
                    if (pack == null || jar == null) {
                        bl2 = false;
                        MCPatcherUtils.close(jar);
                        break block7;
                    }
                    bl = !Arrays.equals(IOUtils.toByteArray((InputStream)jar), IOUtils.toByteArray((InputStream)pack));
                    MCPatcherUtils.close(jar);
                    break block8;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            MCPatcherUtils.close(pack);
            return bl2;
        }
        MCPatcherUtils.close(pack);
        return bl;
        finally {
            MCPatcherUtils.close(jar);
            MCPatcherUtils.close(pack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImage(ResourceLocation resource) {
        if (resource == null) {
            return null;
        }
        InputStream input = TexturePackAPI.getInputStream(resource);
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e) {
                logger.error("could not read %s", resource);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    public static Properties getProperties(ResourceLocation resource) {
        Properties properties = new Properties();
        if (TexturePackAPI.getProperties(resource, properties)) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getProperties(ResourceLocation resource, Properties properties) {
        if (properties != null) {
            InputStream input = TexturePackAPI.getInputStream(resource);
            try {
                if (input != null) {
                    properties.load(input);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                logger.error("could not read %s", resource);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }

    public static ResourceLocation transformResourceLocation(ResourceLocation resource, String oldExt, String newExt) {
        return new ResourceLocation(resource.getResourceDomain(), resource.getResourcePath().replaceFirst(Pattern.quote(oldExt) + "$", newExt));
    }

    public static ResourceLocation parsePath(String path) {
        int slash;
        if (MCPatcherUtils.isNullOrEmpty(path)) {
            return null;
        }
        if ((path = path.replace(File.separatorChar, '/')).startsWith(ASSETS) && (slash = (path = path.substring(ASSETS.length())).indexOf(47)) > 0 && slash + 1 < path.length()) {
            return new ResourceLocation(path.substring(0, slash), path.substring(slash + 1));
        }
        return null;
    }

    public static ResourceLocation parseResourceLocation(ResourceLocation baseResource, String path) {
        int colon;
        if (MCPatcherUtils.isNullOrEmpty(path)) {
            return null;
        }
        boolean absolute = false;
        if (path.startsWith("%blur%")) {
            path = path.substring(6);
        }
        if (path.startsWith("%clamp%")) {
            path = path.substring(7);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
            absolute = true;
        }
        if (path.startsWith("assets/minecraft/")) {
            path = path.substring(17);
            absolute = true;
        }
        if ((colon = path.indexOf(58)) >= 0) {
            return new ResourceLocation(path.substring(0, colon), path.substring(colon + 1));
        }
        ResourceLocation resource = path.startsWith("~/") ? new ResourceLocation(baseResource.getResourceDomain(), MCPATCHER_SUBDIR + path.substring(2)) : (path.startsWith("./") ? new ResourceLocation(baseResource.getResourceDomain(), baseResource.getResourcePath().replaceFirst("[^/]+$", "") + path.substring(2)) : (!absolute && !path.contains("/") ? new ResourceLocation(baseResource.getResourceDomain(), baseResource.getResourcePath().replaceFirst("[^/]+$", "") + path) : new ResourceLocation(baseResource.getResourceDomain(), path)));
        if (baseResource instanceof ResourceLocationWithSource) {
            resource = new ResourceLocationWithSource(((ResourceLocationWithSource)baseResource).getSource(), resource);
        }
        return resource;
    }

    public static ResourceLocation newMCPatcherResourceLocation(String path) {
        return new ResourceLocation(MCPATCHER_SUBDIR + path.replaceFirst("^/+", ""));
    }

    public static int getTextureIfLoaded(ResourceLocation resource) {
        if (resource == null) {
            return -1;
        }
        ITextureObject texture = Minecraft.getMinecraft().getTextureManager().getTexture(resource);
        return texture instanceof AbstractTexture ? texture.getGlTextureId() : -1;
    }

    public static boolean isTextureLoaded(ResourceLocation resource) {
        return TexturePackAPI.getTextureIfLoaded(resource) >= 0;
    }

    public static ITextureObject getTextureObject(ResourceLocation resource) {
        return Minecraft.getMinecraft().getTextureManager().getTexture(resource);
    }

    public static void bindTexture(ResourceLocation resource) {
        if (resource != null) {
            Minecraft.getMinecraft().getTextureManager().bindTexture(resource);
        }
    }

    public static void unloadTexture(ResourceLocation resource) {
        TextureManager textureManager;
        ITextureObject texture;
        if (resource != null && (texture = (textureManager = Minecraft.getMinecraft().getTextureManager()).getTexture(resource)) != null && !(texture instanceof TextureMap) && !(texture instanceof DynamicTexture)) {
            if (texture instanceof AbstractTexture) {
                ((AbstractTextureExpansion)texture).unloadGLTexture();
            }
            logger.finer("unloading texture %s", resource);
            textureManager.mapTextureObjects.remove(resource);
        }
    }

    public static void flushUnusedTextures() {
        TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
        if (textureManager != null) {
            Map.Entry[] arr;
            for (Map.Entry entry : arr = textureManager.mapTextureObjects.entrySet().toArray(new Map.Entry[0])) {
                ResourceLocation resource;
                ITextureObject texture = (ITextureObject)entry.getValue();
                if (!(texture instanceof SimpleTexture) || texture instanceof ThreadDownloadImageData || TexturePackAPI.hasResource(resource = (ResourceLocation)entry.getKey())) continue;
                TexturePackAPI.unloadTexture(resource);
            }
        }
    }
}

