/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.client.gui.ScrollableGuiScreen;
import com.gtnewhorizons.angelica.compat.mojang.Drawable;
import com.gtnewhorizons.angelica.compat.mojang.Element;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import jss.notfine.gui.GuiCustomMenu;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.element.SodiumControlElementFactory;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

public class SodiumOptionsGUI
extends ScrollableGuiScreen {
    protected static final SodiumControlElementFactory elementFactory = new SodiumControlElementFactory();
    protected final List<Element> children = new CopyOnWriteArrayList<Element>();
    protected final List<OptionPage> pages = new ArrayList<OptionPage>();
    protected final List<ControlElement<?>> controls = new ArrayList();
    protected final List<Drawable> drawable = new ArrayList<Drawable>();
    public final GuiScreen prevScreen;
    protected OptionPage currentPage;
    protected FlatButtonWidget applyButton;
    protected FlatButtonWidget closeButton;
    protected FlatButtonWidget undoButton;
    protected boolean hasPendingChanges;
    protected ControlElement<?> hoveredElement;
    protected OptionPage shaderPacks;

    public SodiumOptionsGUI(GuiScreen prevScreen) {
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.advanced());
        this.pages.add(SodiumGameOptionPages.performance());
        if (AngelicaConfig.enableIris) {
            this.shaderPacks = new OptionPage(I18n.format((String)"options.iris.shaderPackSelection", (Object[])new Object[0]), (ImmutableList<OptionGroup>)ImmutableList.of());
            this.pages.add(this.shaderPacks);
        }
    }

    public void setPage(OptionPage page) {
        if (AngelicaConfig.enableIris && page == this.shaderPacks) {
            this.mc.displayGuiScreen((GuiScreen)new ShaderPackScreen(this));
            return;
        }
        this.currentPage = page;
        this.rebuildGUI();
    }

    public void initGui() {
        this.rebuildGUI();
    }

    protected void rebuildGUI() {
        this.controls.clear();
        this.children.clear();
        this.drawable.clear();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.width - 211, this.height - 26, 65, 20), I18n.format((String)"sodium.options.buttons.undo", (Object[])new Object[0]), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.width - 142, this.height - 26, 65, 20), I18n.format((String)"sodium.options.buttons.apply", (Object[])new Object[0]), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.width - 73, this.height - 26, 65, 20), I18n.format((String)"gui.done", (Object[])new Object[0]), this::onClose);
        this.children.add(this.undoButton);
        this.children.add(this.applyButton);
        this.children.add(this.closeButton);
        for (Element element : this.children) {
            if (!(element instanceof Drawable)) continue;
            this.drawable.add((Drawable)((Object)element));
        }
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.fontRendererObj.getStringWidth(page.getName());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, 6, width, 18), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.children.add(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(6, y, 200, 18), elementFactory);
                this.controls.add(element);
                this.children.add((Element)((Object)element));
                y += 18;
            }
            y += 4;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float delta) {
        super.drawScreen(mouseX, mouseY, delta);
        super.drawDefaultBackground();
        this.updateControls();
        for (Drawable drawable : this.drawable) {
            drawable.render(mouseX, mouseY, delta);
        }
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(this.hoveredElement);
        }
    }

    @Override
    public List<? extends Element> children() {
        return this.children;
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(ControlElement::isHovered).findFirst().orElse(null);
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = dim.getOriginY();
        int boxX = dim.getLimitX() + 3;
        Option<?> option = element.getOption();
        ArrayList<String> tooltip = new ArrayList<String>(this.fontRendererObj.listFormattedStringToWidth(option.getTooltip(), 194));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(EnumChatFormatting.GRAY + I18n.format((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.toDisplayString()}));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + 3)) > (boxYCutoff = this.height - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        this.drawGradientRect(boxX, boxY, boxX + 200, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            this.fontRendererObj.drawString((String)tooltip.get(i), boxX + 3, boxY + 3 + i * 12, -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            this.mc.getTextureMapBlocks().setMipmapLevels(this.mc.gameSettings.mipmapLevels);
            this.mc.refreshResources();
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (keyCode == 1 && !this.shouldCloseOnEsc()) {
            return;
        }
        if (keyCode == 1) {
            this.onClose();
            return;
        }
        if (keyCode == 25 && SodiumOptionsGUI.isShiftKeyDown()) {
            this.mc.displayGuiScreen((GuiScreen)new GuiCustomMenu(this.prevScreen, SodiumGameOptionPages.general(), SodiumGameOptionPages.quality(), SodiumGameOptionPages.advanced(), SodiumGameOptionPages.performance()));
        }
    }

    public boolean shouldCloseOnEsc() {
        return !this.hasPendingChanges;
    }

    public void onClose() {
        this.mc.displayGuiScreen(this.prevScreen);
        super.onGuiClosed();
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.children.forEach(element -> element.mouseClicked(mouseX, mouseY, mouseButton));
    }

    protected void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        super.mouseClickMove(mouseX, mouseY, mouseButton, timeSinceLastClick);
        this.children.forEach(element -> element.mouseDragged(mouseX, mouseY, mouseButton));
    }
}

