/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.widgets;

import com.gtnewhorizons.angelica.compat.mojang.Drawable;
import lombok.Generated;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;

public class FlatButtonWidget
extends AbstractWidget
implements Drawable {
    private final Dim2i dim;
    private final String label;
    private final Runnable action;
    private boolean selected;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean leftAligned;

    public FlatButtonWidget(Dim2i dim, String label, Runnable action) {
        this.dim = dim;
        this.label = label;
        this.action = action;
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        boolean hovered = this.dim.containsCursor(mouseX, mouseY);
        int backgroundColor = this.enabled ? (hovered ? -536870912 : -1879048192) : 0x60000000;
        int textColor = this.enabled ? -1 : -1862270977;
        int strWidth = this.font.getStringWidth(this.label);
        this.drawRect(this.dim.getOriginX(), this.dim.getOriginY(), this.dim.getLimitX(), this.dim.getLimitY(), backgroundColor);
        int x = this.leftAligned ? this.dim.getOriginX() + 10 : this.dim.getCenterX() - strWidth / 2;
        this.drawString(this.label, x, this.dim.getCenterY() - 4, textColor);
        if (this.enabled && this.selected) {
            this.drawRect(this.dim.getOriginX(), this.leftAligned ? (double)this.dim.getOriginY() : (double)(this.dim.getLimitY() - 1), this.leftAligned ? (double)(this.dim.getOriginX() + 1) : (double)this.dim.getLimitX(), this.dim.getLimitY(), -7019309);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.enabled || !this.visible) {
            return false;
        }
        if (button == 0 && this.dim.containsCursor(mouseX, mouseY)) {
            this.action.run();
            this.playClickSound();
            return true;
        }
        return false;
    }

    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Generated
    public void setLeftAligned(boolean leftAligned) {
        this.leftAligned = leftAligned;
    }
}

