/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.block;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public class BlockStateMatcher {
    private final String fullString;
    private final ThreadLocal<Object> threadLocal = new ThreadLocal();
    protected final Block block;
    protected Object data;
    private static final int MAX_METADATA = 15;
    private static final int NO_METADATA = -1;
    private final int metadataBits;
    private static Block doublePlantBlock;
    private static Block logBlock;

    public BlockStateMatcher(String metaString, Block block, String metadataList) {
        this.fullString = BlockAPI.getBlockName(block) + metaString;
        this.block = block;
        if (MCPatcherUtils.isNullOrEmpty(metadataList)) {
            this.metadataBits = -1;
        } else {
            int bits = 0;
            for (int i : MCPatcherUtils.parseIntegerList(metadataList, 0, 15)) {
                bits |= 1 << i;
            }
            this.metadataBits = bits;
        }
        doublePlantBlock = (Block)GameData.getBlockRegistry().func_82594_a("minecraft:double_plant");
        logBlock = (Block)GameData.getBlockRegistry().func_82594_a("minecraft:log");
    }

    public final Block getBlock() {
        return this.block;
    }

    public final Object getData() {
        return this.data;
    }

    public final void setData(Object data) {
        this.data = data;
    }

    public final Object getThreadData() {
        return this.threadLocal.get();
    }

    public final void setThreadData(Object data) {
        this.threadLocal.set(data);
    }

    public final String toString() {
        return this.fullString;
    }

    public boolean match(IBlockAccess blockAccess, int x, int y, int z) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (block != this.block) {
            return false;
        }
        int metadata = blockAccess.func_72805_g(x, y, z);
        if (block == doublePlantBlock) {
            if ((metadata & 8) != 0 && blockAccess.func_147439_a(x, y - 1, z) == block) {
                metadata = blockAccess.func_72805_g(x, y - 1, z);
            }
            metadata &= 7;
        } else if (block == logBlock) {
            metadata &= 0xFFFFFFF3;
        }
        return (this.metadataBits & 1 << metadata) != 0;
    }

    public boolean match(Block block, int metadata) {
        return block == this.block && (this.metadataBits & 1 << metadata) != 0;
    }
}

