/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.mojang.InteractionHand;
import com.gtnewhorizons.angelica.compat.toremove.RenderLayer;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import java.nio.FloatBuffer;
import java.util.Map;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    private boolean ACTIVE;
    private boolean renderingSolid;
    public static final float DEPTH = 0.125f;

    private void setupGlState(RenderGlobal gameRenderer, Camera camera, float tickDelta) {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)0.125f);
        if (mc.field_71460_t.field_78503_V != 1.0) {
            GL11.glTranslatef((float)((float)mc.field_71460_t.field_78502_W), (float)((float)(-mc.field_71460_t.field_78509_X)), (float)0.0f);
            GL11.glScaled((double)mc.field_71460_t.field_78503_V, (double)mc.field_71460_t.field_78503_V, (double)1.0);
        }
        Project.gluPerspective((float)mc.field_71460_t.func_78481_a(tickDelta, false), (float)((float)mc.field_71443_c / (float)mc.field_71440_d), (float)0.05f, (float)(mc.field_71460_t.field_78530_s * 2.0f));
        if (mc.field_71442_b.func_78747_a()) {
            GL11.glScalef((float)1.0f, (float)0.6666667f, (float)1.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        mc.field_71460_t.func_78482_e(tickDelta);
        if (mc.field_71474_y.field_74336_f) {
            mc.field_71460_t.func_78475_f(tickDelta);
        }
    }

    private boolean canRender(Camera camera, RenderGlobal gameRenderer) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71460_t.field_78532_q <= 0 && mc.field_71474_y.field_74320_O == 0 && !camera.getEntity().func_70608_bn() && !mc.field_71474_y.field_74319_N && !mc.field_71442_b.func_78747_a();
    }

    public boolean isHandTranslucent(InteractionHand hand) {
        ItemStack heldItem = hand.getItemInHand((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (heldItem == null) {
            return false;
        }
        Item item = heldItem.func_77973_b();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Map<Block, RenderLayer> blockTypeIds = BlockRenderingSettings.INSTANCE.getBlockTypeIds();
            return blockTypeIds != null && blockTypeIds.get(itemBlock.field_150939_a) == RenderLayer.translucent();
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(InteractionHand.MAIN_HAND) || this.isHandTranslucent(InteractionHand.OFF_HAND);
    }

    public void renderSolid(float tickDelta, Camera camera, RenderGlobal gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !IrisApi.getInstance().isShaderPackInUse()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        mc.field_71424_I.func_76320_a("iris_hand");
        this.setupGlState(gameRenderer, camera, tickDelta);
        this.renderingSolid = true;
        mc.field_71460_t.func_78463_b((double)tickDelta);
        mc.field_71460_t.field_78516_c.func_78440_a(tickDelta);
        mc.field_71460_t.func_78483_a((double)tickDelta);
        GLStateManager.defaultBlendFunc();
        GL11.glDepthMask((boolean)false);
        GL11.glPopMatrix();
        mc.field_71424_I.func_76319_b();
        this.resetProjectionMatrix();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(float tickDelta, Camera camera, RenderGlobal gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && IrisApi.getInstance().isShaderPackInUse())) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        GL11.glPushMatrix();
        mc.field_71424_I.func_76320_a("iris_hand_translucent");
        this.setupGlState(gameRenderer, camera, tickDelta);
        mc.field_71460_t.func_78463_b((double)tickDelta);
        mc.field_71460_t.field_78516_c.func_78440_a(tickDelta);
        mc.field_71460_t.func_78483_a((double)tickDelta);
        GL11.glPopMatrix();
        this.resetProjectionMatrix();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    private void resetProjectionMatrix() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMultMatrix((FloatBuffer)RenderingState.INSTANCE.getProjectionBuffer());
        GL11.glMatrixMode((int)5888);
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }
}

