/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.element.IrisGuiSlot;
import net.coderbot.iris.gui.element.shaderselection.BaseEntry;
import net.coderbot.iris.gui.element.shaderselection.LabelEntry;
import net.coderbot.iris.gui.element.shaderselection.ShaderPackEntry;
import net.coderbot.iris.gui.element.shaderselection.TopButtonRowEntry;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;

public class ShaderPackSelectionList
extends IrisGuiSlot {
    private final ShaderPackScreen screen;
    private final TopButtonRowEntry topButtonRow;
    private ShaderPackEntry applied = null;
    private ShaderPackEntry selected = null;
    private final List<BaseEntry> entries = new ArrayList<BaseEntry>();

    public ShaderPackSelectionList(ShaderPackScreen screen, Minecraft client, int width, int height, int top, int bottom, int left, int right) {
        super(client, width, height, top, bottom, 20);
        this.screen = screen;
        this.topButtonRow = new TopButtonRowEntry(this, Iris.getIrisConfig().areShadersEnabled());
        this.refresh();
    }

    public void refresh() {
        Collection<String> names;
        this.entries.clear();
        try {
            names = Iris.getShaderpacksDirectoryManager().enumerate();
        }
        catch (Throwable e) {
            Iris.logger.error("Error reading files while constructing selection UI", e);
            this.addLabelEntries("", "There was an error reading your shaderpacks directory", "", "Check your logs for more information.", "Please file an issue report including a log file.", "If you are able to identify the file causing this, please include it in your report as well.", "Note that this might be an issue with folder permissions; ensure those are correct first.");
            return;
        }
        this.entries.add(this.topButtonRow);
        this.topButtonRow.allowEnableShadersButton = names.size() > 0;
        int index = 0;
        for (String name : names) {
            this.addPackEntry(++index, name);
        }
    }

    public void addPackEntry(int index, String name) {
        ShaderPackEntry entry = new ShaderPackEntry(this, name);
        Iris.getIrisConfig().getShaderPackName().ifPresent(currentPackName -> {
            if (name.equals(currentPackName)) {
                this.setSelected(entry);
                this.setApplied(entry);
            }
        });
        this.entries.add(entry);
    }

    public void addLabelEntries(String ... lines) {
        for (String text : lines) {
            this.entries.add(new LabelEntry(this, text));
        }
    }

    public void select(String name) {
        for (BaseEntry entry : this.entries) {
            ShaderPackEntry shaderPackEntry;
            if (!(entry instanceof ShaderPackEntry) || !name.equals((shaderPackEntry = (ShaderPackEntry)entry).getPackName())) continue;
            this.setSelected(shaderPackEntry);
            return;
        }
    }

    protected int getSize() {
        return this.entries.size();
    }

    @Override
    protected boolean elementClicked(int index, boolean doubleClick, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton != 0) {
            return false;
        }
        BaseEntry entry = this.entries.get(index);
        if (entry instanceof ShaderPackEntry) {
            ShaderPackEntry shaderPackEntry = (ShaderPackEntry)entry;
            this.setSelected(shaderPackEntry);
            if (!this.topButtonRow.shadersEnabled) {
                this.topButtonRow.setShadersEnabled(true);
            }
            return true;
        }
        if (entry instanceof TopButtonRowEntry) {
            TopButtonRowEntry topButtonRowEntry = (TopButtonRowEntry)entry;
            return topButtonRowEntry.mouseClicked(mouseX, mouseY, 0);
        }
        return false;
    }

    protected boolean isSelected(int idx) {
        return this.entries.get(idx).equals(this.selected);
    }

    public int getListWidth() {
        return Math.min(308, this.width - 50);
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int index, int x, int y, int i1, Tessellator tessellator, int mouseX, int mouseY) {
        BaseEntry entry = this.entries.get(index);
        boolean isMouseOver = this.func_148124_c(mouseX, mouseY) == index;
        entry.drawEntry(this.screen, index, x - 2, y + 4, this.getListWidth(), tessellator, mouseX, mouseY, isMouseOver);
    }

    @Generated
    public ShaderPackScreen getScreen() {
        return this.screen;
    }

    @Generated
    public TopButtonRowEntry getTopButtonRow() {
        return this.topButtonRow;
    }

    @Generated
    public void setApplied(ShaderPackEntry applied) {
        this.applied = applied;
    }

    @Generated
    public ShaderPackEntry getApplied() {
        return this.applied;
    }

    @Generated
    public void setSelected(ShaderPackEntry selected) {
        this.selected = selected;
    }

    @Generated
    public ShaderPackEntry getSelected() {
        return this.selected;
    }
}

