/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.asm;

import com.gtnewhorizons.angelica.loading.shared.AngelicaClassDump;
import jss.notfine.asm.ASMUtils;
import jss.notfine.asm.mappings.Names;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WorldRendererTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.client.renderer.WorldRenderer".equals(transformedName)) {
            byte[] bytes = WorldRendererTransformer.patchWorldRenderer(basicClass);
            AngelicaClassDump.dumpClass(transformedName, basicClass, bytes, this);
            return bytes;
        }
        return basicClass;
    }

    private static byte[] patchWorldRenderer(byte[] basicClass) {
        Logger logger = LogManager.getLogger((String)"MCPatcherForge");
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        boolean beginInjected = false;
        boolean updateRendererHandled = false;
        AbstractInsnNode[] sequence = WorldRendererTransformer.getSearchSequence();
        int lineNumberShifter = 0;
        for (MethodNode methodNode : classNode.methods) {
            if (WorldRendererTransformer.isUpdateRenderer(methodNode)) {
                logger.debug("found updateRenderer");
                for (AbstractInsnNode node : methodNode.instructions.toArray()) {
                    if (ASMUtils.matchesNodeSequence(node, sequence)) {
                        AbstractInsnNode trackingNode = node.getNext().getNext().getNext().getNext().getNext();
                        if (trackingNode instanceof LineNumberNode) {
                            LineNumberNode lineNumberNode = (LineNumberNode)trackingNode;
                            lineNumberShifter = lineNumberNode.line;
                        }
                        if (trackingNode.getNext() instanceof VarInsnNode) {
                            methodNode.instructions.remove(trackingNode.getNext());
                            methodNode.instructions.insert(trackingNode, (AbstractInsnNode)new VarInsnNode(25, 24));
                        }
                        if ((trackingNode = trackingNode.getNext().getNext()) instanceof VarInsnNode) {
                            VarInsnNode aLoadNode = (VarInsnNode)trackingNode;
                            aLoadNode.var = 18;
                        }
                        InsnList list1 = new InsnList();
                        list1.add((AbstractInsnNode)new MethodInsnNode(184, "com/prupe/mcpatcher/renderpass/RenderPass", "checkRenderPasses", "(" + Names.block_.desc + "Z)Z", false));
                        list1.add((AbstractInsnNode)new VarInsnNode(54, 18));
                        methodNode.instructions.insert(trackingNode, list1);
                        trackingNode = trackingNode.getNext().getNext();
                        methodNode.instructions.remove(trackingNode.getNext().getNext().getNext().getNext().getNext());
                        methodNode.instructions.remove(trackingNode.getNext().getNext().getNext().getNext());
                        methodNode.instructions.remove(trackingNode.getNext().getNext().getNext());
                        methodNode.instructions.remove(trackingNode.getNext().getNext());
                        methodNode.instructions.remove(trackingNode.getNext());
                        trackingNode = trackingNode.getNext().getNext();
                        methodNode.instructions.remove(trackingNode.getNext());
                        trackingNode = trackingNode.getNext().getNext().getNext().getNext().getNext().getNext().getNext();
                        methodNode.instructions.remove(trackingNode.getNext());
                        methodNode.instructions.insert(trackingNode, (AbstractInsnNode)new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
                        beginInjected = true;
                        continue;
                    }
                    if (!beginInjected || !(node instanceof LineNumberNode)) continue;
                    LineNumberNode lineNumberNode1 = (LineNumberNode)node;
                    if (lineNumberNode1.line <= lineNumberShifter) continue;
                    lineNumberNode1.line -= 3;
                }
                updateRendererHandled = true;
                continue;
            }
            if (!updateRendererHandled) continue;
            for (AbstractInsnNode node : methodNode.instructions.toArray()) {
                if (!(node instanceof LineNumberNode)) continue;
                LineNumberNode lineNumberNode = (LineNumberNode)node;
                lineNumberNode.line -= 3;
            }
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    private static AbstractInsnNode[] getSearchSequence() {
        FrameNode searchNode1 = new FrameNode(3, 0, null, 0, null);
        VarInsnNode searchNode2 = new VarInsnNode(25, 24);
        MethodInsnNode searchNode3 = new MethodInsnNode(182, Names.block_getRenderBlockPass.clas, Names.block_getRenderBlockPass.name, Names.block_getRenderBlockPass.desc, false);
        VarInsnNode searchNode4 = new VarInsnNode(54, 25);
        return new AbstractInsnNode[]{searchNode1, searchNode2, searchNode3, searchNode4};
    }

    private static boolean isUpdateRenderer(MethodNode methodNode) {
        return Names.worldRenderer_updateRenderer.equalsNameDesc(methodNode.name, methodNode.desc);
    }
}

