/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.ctm.RenderBlockState;
import com.prupe.mcpatcher.ctm.TileOverride;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import com.prupe.mcpatcher.mal.util.WeightedIndex;
import net.minecraft.util.IIcon;

class TileOverrideImpl {
    TileOverrideImpl() {
    }

    static final class Fixed
    extends TileOverride {
        Fixed(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "fixed";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 1) {
                return null;
            }
            return "requires exactly 1 tile";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[0];
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[0];
        }
    }

    static final class Repeat
    extends TileOverride {
        private final int width;
        private final int height;
        private final int symmetry;

        Repeat(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
            String sym;
            this.width = properties.getInt("width", 0);
            this.height = properties.getInt("height", 0);
            if (this.width <= 0 || this.height <= 0) {
                properties.error("invalid width and height (%dx%d)", this.width, this.height);
            }
            this.symmetry = (sym = properties.getString("symmetry", "none")).equals("opposite") ? -2 : -1;
        }

        @Override
        String getMethod() {
            return "repeat";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == this.width * this.height) {
                return null;
            }
            return String.format("requires exactly %dx%d tiles", this.width, this.height);
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            int face = renderBlockState.getBlockFace();
            if (face < 0) {
                face = 0;
            }
            int x = renderBlockState.getX();
            int y = renderBlockState.getY();
            int z = renderBlockState.getZ();
            int[] xOffset = renderBlockState.getOffset(face &= this.symmetry, 4);
            int[] yOffset = renderBlockState.getOffset(face, 2);
            int offsetX = x * xOffset[0] + y * xOffset[1] + z * xOffset[2];
            int offsetY = x * yOffset[0] + y * yOffset[1] + z * yOffset[2];
            if (face == 2 || face == 5) {
                --offsetX;
            }
            if ((offsetX %= this.width) < 0) {
                offsetX += this.width;
            }
            if ((offsetY %= this.height) < 0) {
                offsetY += this.height;
            }
            return this.icons[this.width * offsetY + offsetX];
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[0];
        }
    }

    static final class Random1
    extends TileOverride {
        private final int symmetry;
        private final boolean linked;
        private final WeightedIndex chooser;

        Random1(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
            String sym = properties.getString("symmetry", "none");
            this.symmetry = sym.equals("all") ? 6 : (sym.equals("opposite") ? 2 : 1);
            this.linked = properties.getBoolean("linked", false);
            this.chooser = WeightedIndex.create(this.getNumberOfTiles(), properties.getString("weights", ""));
            if (this.chooser == null) {
                properties.error("invalid weights", new Object[0]);
            }
        }

        @Override
        String getMethod() {
            return "random";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            int face = renderBlockState.getBlockFace();
            if (face < 0) {
                face = 0;
            }
            int x = renderBlockState.getX();
            int y = renderBlockState.getY();
            int z = renderBlockState.getZ();
            if (this.linked && renderBlockState.setCoordOffsetsForRenderType()) {
                x += renderBlockState.getDX();
                y += renderBlockState.getDY();
                z += renderBlockState.getDZ();
            }
            long hash = WeightedIndex.hash128To64(x, y, z, face / this.symmetry);
            int index = this.chooser.choose(hash);
            return this.icons[index];
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[0];
        }
    }

    static final class Top
    extends TileOverride {
        Top(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "top";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 1) {
                return null;
            }
            return "requires exactly 1 tile";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            int face = renderBlockState.getBlockFace();
            if (face < 0) {
                face = 2;
            } else if (face <= 1) {
                return null;
            }
            if (this.shouldConnect(renderBlockState, origIcon, face, 6)) {
                return this.icons[0];
            }
            return null;
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return null;
        }
    }

    static final class VerticalHorizontal
    extends Vertical {
        private static final int[] neighborMap = new int[]{3, 6, 3, 3, 3, 6, 3, 3, 4, 5, 4, 4, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

        VerticalHorizontal(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "vertical+horizontal";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 7) {
                return null;
            }
            return "requires exactly 7 tiles";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            IIcon icon = super.getTileWorld_Impl(renderBlockState, origIcon);
            if (icon != this.icons[3]) {
                return icon;
            }
            int neighborBits = 0;
            if (this.shouldConnect(renderBlockState, origIcon, 0)) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 1)) {
                neighborBits |= 2;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 3)) {
                neighborBits |= 4;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 4)) {
                neighborBits |= 8;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 5)) {
                neighborBits |= 0x10;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 7)) {
                neighborBits |= 0x20;
            }
            return this.icons[neighborMap[neighborBits]];
        }
    }

    static class Vertical
    extends TileOverride {
        private static final int[] neighborMap = new int[]{3, 2, 0, 1};

        Vertical(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "vertical";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 4) {
                return null;
            }
            return "requires exactly 4 tiles";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            int face = renderBlockState.getFaceForHV();
            if (face < 0) {
                return null;
            }
            int neighborBits = 0;
            if (this.shouldConnect(renderBlockState, origIcon, 2)) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 6)) {
                neighborBits |= 2;
            }
            return this.icons[neighborMap[neighborBits]];
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[3];
        }
    }

    static final class HorizontalVertical
    extends Horizontal {
        private static final int[] neighborMap = new int[]{3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 4, 4, 5, 4, 4, 4, 4, 4, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3};

        HorizontalVertical(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "horizontal+vertical";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 7) {
                return null;
            }
            return "requires exactly 7 tiles";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            IIcon icon = super.getTileWorld_Impl(renderBlockState, origIcon);
            if (icon != this.icons[3]) {
                return icon;
            }
            int neighborBits = 0;
            if (this.shouldConnect(renderBlockState, origIcon, 1)) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 2)) {
                neighborBits |= 2;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 3)) {
                neighborBits |= 4;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 5)) {
                neighborBits |= 8;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 6)) {
                neighborBits |= 0x10;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 7)) {
                neighborBits |= 0x20;
            }
            return this.icons[neighborMap[neighborBits]];
        }
    }

    static class Horizontal
    extends TileOverride {
        private static final int[] neighborMap = new int[]{3, 2, 0, 1};

        Horizontal(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "horizontal";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 4) {
                return null;
            }
            return "requires exactly 4 tiles";
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            int face = renderBlockState.getFaceForHV();
            if (face < 0) {
                return null;
            }
            int neighborBits = 0;
            if (this.shouldConnect(renderBlockState, origIcon, 0)) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(renderBlockState, origIcon, 4)) {
                neighborBits |= 2;
            }
            return this.icons[neighborMap[neighborBits]];
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[3];
        }
    }

    static final class CTM
    extends TileOverride {
        private static final int[] neighborMap = new int[]{0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 16, 18, 16, 18, 6, 46, 6, 21, 16, 18, 16, 18, 28, 9, 28, 22, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 37, 40, 37, 40, 30, 8, 30, 34, 37, 40, 37, 40, 25, 23, 25, 45, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 16, 42, 16, 42, 6, 20, 6, 10, 16, 42, 16, 42, 28, 35, 28, 44, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 37, 38, 37, 38, 30, 11, 30, 32, 37, 38, 37, 38, 25, 33, 25, 26};

        CTM(PropertiesFile properties, TileLoader tileLoader) {
            super(properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "ctm";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() >= 47) {
                return null;
            }
            return "requires at least 47 tiles";
        }

        @Override
        boolean requiresFace() {
            return true;
        }

        @Override
        IIcon getTileWorld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            int neighborBits = 0;
            for (int bit = 0; bit < 8; ++bit) {
                if (!this.shouldConnect(renderBlockState, origIcon, bit)) continue;
                neighborBits |= 1 << bit;
            }
            return this.icons[neighborMap[neighborBits]];
        }

        @Override
        IIcon getTileHeld_Impl(RenderBlockState renderBlockState, IIcon origIcon) {
            return this.icons[0];
        }
    }
}

