/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.materialmap;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BlockEntry {
    private final NamespacedId id;
    private final Set<Integer> metas;

    public BlockEntry(NamespacedId id, Set<Integer> metas) {
        this.id = id;
        this.metas = metas;
    }

    @NotNull
    public static BlockEntry parse(@NotNull String entry) {
        NamespacedId id;
        int statesStart;
        if (entry.isEmpty()) {
            throw new IllegalArgumentException("Called BlockEntry::parse with an empty string");
        }
        String[] splitStates = entry.split(":");
        if (splitStates.length == 1) {
            return new BlockEntry(new NamespacedId("minecraft", entry), Collections.emptySet());
        }
        if (splitStates.length == 2 && !StringUtils.isNumeric((CharSequence)splitStates[1].substring(0, 1))) {
            return new BlockEntry(new NamespacedId(splitStates[0], splitStates[1]), Collections.emptySet());
        }
        if (StringUtils.isNumeric((CharSequence)splitStates[1].substring(0, 1))) {
            statesStart = 1;
            id = new NamespacedId("minecraft", splitStates[0]);
        } else {
            statesStart = 2;
            id = new NamespacedId(splitStates[0], splitStates[1]);
        }
        HashSet<Integer> metas = new HashSet<Integer>();
        for (int index = statesStart; index < splitStates.length; ++index) {
            String[] metaParts;
            for (String metaPart : metaParts = splitStates[index].split(", ")) {
                try {
                    metas.add(Integer.parseInt(metaPart));
                }
                catch (NumberFormatException e) {
                    Iris.logger.warn("Warning: the block ID map entry \"" + entry + "\" could not be fully parsed:");
                    Iris.logger.warn("- Metadata ids must be a comma separated list of one or more integers, but " + splitStates[index] + " is not of that form!");
                }
            }
        }
        return new BlockEntry(id, metas);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockEntry that = (BlockEntry)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.metas, that.metas);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.metas);
    }

    @Generated
    public NamespacedId getId() {
        return this.id;
    }

    @Generated
    public Set<Integer> getMetas() {
        return this.metas;
    }
}

