/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import com.gtnewhorizons.angelica.glsm.GLDebug;
import me.jellysquid.mods.sodium.client.gl.GlObject;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderBindingPoint;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

public abstract class GlProgram
extends GlObject {
    private static final Logger LOGGER = LogManager.getLogger(GlProgram.class);
    private final ResourceLocation name;

    protected GlProgram(RenderDevice owner, ResourceLocation name, int program) {
        super(owner);
        this.name = name;
        this.setHandle(program);
    }

    public static Builder builder(ResourceLocation identifier) {
        return new Builder(identifier);
    }

    public void bind() {
        GL20.glUseProgram((int)this.handle());
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getUniformLocation(String name) {
        int index = GL20.glGetUniformLocation((int)this.handle(), (CharSequence)name);
        if (index < 0) {
            throw new NullPointerException("No uniform exists with name: " + name);
        }
        return index;
    }

    public void delete() {
        GL20.glDeleteProgram((int)this.handle());
        this.invalidateHandle();
    }

    public static class Builder {
        private final ResourceLocation name;
        private final int program;

        public Builder(ResourceLocation name) {
            this.name = name;
            this.program = GL20.glCreateProgram();
            GLDebug.nameObject(33506, this.program, name.toString());
        }

        public Builder attachShader(GlShader shader) {
            GL20.glAttachShader((int)this.program, (int)shader.handle());
            return this;
        }

        public <P extends GlProgram> P build(ProgramFactory<P> factory) {
            int result;
            GL20.glLinkProgram((int)this.program);
            String log = GL20.glGetProgramInfoLog((int)this.program, (int)35716);
            if (!log.isEmpty()) {
                LOGGER.warn("Program link log for " + this.name + ": " + log);
            }
            if ((result = GL20.glGetProgrami((int)this.program, (int)35714)) != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
            return factory.create(this.name, this.program);
        }

        public Builder bindAttribute(String name, ShaderBindingPoint binding) {
            GL20.glBindAttribLocation((int)this.program, (int)binding.getGenericAttributeIndex(), (CharSequence)name);
            return this;
        }
    }

    public static interface ProgramFactory<P extends GlProgram> {
        public P create(ResourceLocation var1, int var2);
    }
}

