/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.io.PrintStream;
import java.util.function.Consumer;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.AMDDebugOutputCallback;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ARBDebugOutputCallback;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;

public final class GLDebug {
    private static DebugState debugState;

    public static int setupDebugMessageCallback() {
        if (Thread.currentThread() != GLStateManager.getMainThread()) {
            AngelicaTweaker.LOGGER.warn("setupDebugMessageCallback called from non-main thread!");
            return 0;
        }
        return GLDebug.setupDebugMessageCallback(System.err);
    }

    private static void trace(Consumer<String> output) {
        StackTraceElement[] elems;
        for (StackTraceElement ste : elems = GLDebug.filterStackTrace(new Throwable(), 4).getStackTrace()) {
            output.accept(ste.toString());
        }
    }

    public static Throwable filterStackTrace(Throwable throwable, int offset) {
        StackTraceElement[] elems = throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            String className = elems[i].getClassName();
            if (className == null) {
                className = "";
            }
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        throwable.setStackTrace(newElems);
        return throwable;
    }

    public static void printTrace(final PrintStream stream) {
        GLDebug.trace(new Consumer<String>(){
            boolean first = true;

            @Override
            public void accept(String str) {
                if (this.first) {
                    GLDebug.printDetail(stream, "Stacktrace", str);
                    this.first = false;
                } else {
                    GLDebug.printDetailLine(stream, "Stacktrace", str);
                }
            }
        });
    }

    public static int setupDebugMessageCallback(PrintStream stream) {
        if (GLStateManager.capabilities.OpenGL43 || GLStateManager.capabilities.GL_KHR_debug) {
            AngelicaTweaker.LOGGER.info("[GL] Using OpenGL 4.3 for error logging.");
            KHRDebugCallback proc = new KHRDebugCallback((source, type, id, severity, message) -> {
                stream.println("[LWJGL] OpenGL debug message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getDebugSource(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getDebugType(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getDebugSeverity(severity));
                GLDebug.printDetail(stream, "Message", message);
                GLDebug.printTrace(stream);
            });
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37190, null, (boolean)true);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37191, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)37192, null, (boolean)false);
            GL43.glDebugMessageControl((int)4352, (int)4352, (int)33387, null, (boolean)false);
            GL43.glDebugMessageCallback((KHRDebugCallback)proc);
            if ((GL11.glGetInteger((int)33310) & 2) == 0) {
                AngelicaTweaker.LOGGER.warn("[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable((int)37600);
                return 2;
            }
            return 1;
        }
        if (GLStateManager.capabilities.GL_ARB_debug_output) {
            AngelicaTweaker.LOGGER.info("[GL] Using ARB_debug_output for error logging.");
            ARBDebugOutputCallback proc = new ARBDebugOutputCallback((source, type, id, severity, message) -> {
                stream.println("[LWJGL] ARB_debug_output message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Source", GLDebug.getSourceARB(source));
                GLDebug.printDetail(stream, "Type", GLDebug.getTypeARB(type));
                GLDebug.printDetail(stream, "Severity", GLDebug.getSeverityARB(severity));
                GLDebug.printDetail(stream, "Message", message);
                GLDebug.printTrace(stream);
            });
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37190, null, (boolean)true);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37191, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)37192, null, (boolean)false);
            ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)33387, null, (boolean)false);
            ARBDebugOutput.glDebugMessageCallbackARB((ARBDebugOutputCallback)proc);
            return 1;
        }
        if (GLStateManager.capabilities.GL_AMD_debug_output) {
            AngelicaTweaker.LOGGER.info("[GL] Using AMD_debug_output for error logging.");
            AMDDebugOutputCallback proc = new AMDDebugOutputCallback((id, category, severity, message) -> {
                stream.println("[LWJGL] AMD_debug_output message");
                GLDebug.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebug.printDetail(stream, "Category", GLDebug.getCategoryAMD(category));
                GLDebug.printDetail(stream, "Severity", GLDebug.getSeverityAMD(severity));
                GLDebug.printDetail(stream, "Message", message);
                GLDebug.printTrace(stream);
            });
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37190, null, (boolean)true);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37191, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)37192, null, (boolean)false);
            AMDDebugOutput.glDebugMessageEnableAMD((int)0, (int)33387, null, (boolean)false);
            AMDDebugOutput.glDebugMessageCallbackAMD((AMDDebugOutputCallback)proc);
            return 1;
        }
        AngelicaTweaker.LOGGER.info("[GL] No debug output implementation is available, cannot return debug info.");
        return 0;
    }

    public static int disableDebugMessages() {
        if (GLStateManager.capabilities.OpenGL43) {
            GL43.glDebugMessageCallback(null);
            return 1;
        }
        if (GLStateManager.capabilities.GL_KHR_debug) {
            KHRDebug.glDebugMessageCallback(null);
            if (GLStateManager.capabilities.OpenGL30 && (GL11.glGetInteger((int)33310) & 2) == 0) {
                GL11.glDisable((int)37600);
            }
            return 1;
        }
        if (GLStateManager.capabilities.GL_ARB_debug_output) {
            ARBDebugOutput.glDebugMessageCallbackARB(null);
            return 1;
        }
        if (GLStateManager.capabilities.GL_AMD_debug_output) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null);
            return 1;
        }
        AngelicaTweaker.LOGGER.info("[GL] No debug output implementation is available, cannot disable debug info.");
        return 0;
    }

    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("\t%s: %s\n", type, message);
    }

    private static void printDetailLine(PrintStream stream, String type, String message) {
        stream.append("    ");
        for (int i = 0; i < type.length(); ++i) {
            stream.append(" ");
        }
        stream.append(message).append("\n");
    }

    private static String getDebugSource(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", source);
            }
        }
        return string;
    }

    private static String getDebugType(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            case 33384: {
                string = "MARKER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", type);
            }
        }
        return string;
    }

    private static String getDebugSeverity(int severity) {
        String string;
        switch (severity) {
            case 33387: {
                string = "NOTIFICATION";
                break;
            }
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    private static String getSourceARB(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", source);
            }
        }
        return string;
    }

    private static String getTypeARB(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", type);
            }
        }
        return string;
    }

    private static String getSeverityARB(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    private static String getCategoryAMD(int category) {
        String string;
        switch (category) {
            case 37193: {
                string = "API ERROR";
                break;
            }
            case 37194: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 37195: {
                string = "DEPRECATION";
                break;
            }
            case 37196: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 37197: {
                string = "PERFORMANCE";
                break;
            }
            case 37198: {
                string = "SHADER COMPILER";
                break;
            }
            case 37199: {
                string = "APPLICATION";
                break;
            }
            case 37200: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", category);
            }
        }
        return string;
    }

    private static String getSeverityAMD(int severity) {
        String string;
        switch (severity) {
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    public static void initDebugState() {
        debugState = GLStateManager.capabilities.GL_KHR_debug || GLStateManager.capabilities.OpenGL43 ? new KHRDebugState() : new UnsupportedDebugState();
    }

    public static void nameObject(int id, int object, String name) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.nameObject(id, object, name);
        }
    }

    public static void pushGroup(String group) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.pushGroup(group);
        }
    }

    public static void popGroup() {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.popGroup();
        }
    }

    public static void debugMessage(String message) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            debugState.debugMessage(message);
        }
    }

    public static String getObjectLabel(int glProgram, int program) {
        if (debugState != null && Thread.currentThread() == GLStateManager.getMainThread()) {
            return debugState.getObjectLabel(glProgram, program);
        }
        return "";
    }

    private static class KHRDebugState
    implements DebugState {
        private static final int ID = 0;
        private int depth = 0;
        private static final int maxDepth = GL11.glGetInteger((int)33388);
        private static final int maxNameLength = GL11.glGetInteger((int)33512);

        private KHRDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
            KHRDebug.glObjectLabel((int)id, (int)object, (CharSequence)name);
        }

        @Override
        public void pushGroup(String name) {
            ++this.depth;
            if (this.depth > maxDepth) {
                throw new RuntimeException("Stack overflow");
            }
            KHRDebug.glPushDebugGroup((int)33354, (int)0, (CharSequence)name);
        }

        @Override
        public void popGroup() {
            --this.depth;
            if (this.depth < 0) {
                throw new RuntimeException("Stack underflow");
            }
            KHRDebug.glPopDebugGroup();
        }

        @Override
        public void debugMessage(String message) {
            KHRDebug.glDebugMessageInsert((int)33354, (int)33384, (int)0, (int)33387, (CharSequence)message);
        }

        @Override
        public String getObjectLabel(int glProgram, int program) {
            if (program == 0) {
                return "";
            }
            return KHRDebug.glGetObjectLabel((int)glProgram, (int)program, (int)maxNameLength);
        }
    }

    private static interface DebugState {
        public void nameObject(int var1, int var2, String var3);

        public void pushGroup(String var1);

        public void popGroup();

        public void debugMessage(String var1);

        public String getObjectLabel(int var1, int var2);
    }

    private static class UnsupportedDebugState
    implements DebugState {
        private UnsupportedDebugState() {
        }

        @Override
        public void nameObject(int id, int object, String name) {
        }

        @Override
        public void pushGroup(String name) {
        }

        @Override
        public void popGroup() {
        }

        @Override
        public void debugMessage(String name) {
        }

        @Override
        public String getObjectLabel(int glProgram, int program) {
            return "";
        }
    }
}

