/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.notfine.clouds;

import jss.notfine.core.Settings;
import jss.notfine.gui.options.named.GraphicsQualityOff;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RenderGlobal.class}, priority=990)
public abstract class MixinRenderGlobal {
    @Shadow
    @Final
    private static ResourceLocation locationCloudsPng;
    @Shadow
    @Final
    private TextureManager renderEngine;
    @Shadow
    private WorldClient theWorld;
    @Shadow
    private Minecraft mc;
    @Shadow
    private int cloudTickCounter;

    @Overwrite
    public void renderClouds(float partialTicks) {
        IRenderHandler renderer = this.theWorld.provider.getCloudRenderer();
        if (renderer != null) {
            renderer.render(partialTicks, this.theWorld, this.mc);
            return;
        }
        if (this.mc.theWorld.provider.isSurfaceWorld()) {
            GraphicsQualityOff cloudMode = (GraphicsQualityOff)Settings.MODE_CLOUDS.option.getStore();
            if (cloudMode == GraphicsQualityOff.FANCY || cloudMode == GraphicsQualityOff.DEFAULT && this.mc.gameSettings.fancyGraphics) {
                this.renderCloudsFancy(partialTicks);
            } else {
                this.renderCloudsFast(partialTicks);
            }
        }
    }

    @Overwrite
    public void renderCloudsFancy(float partialTicks) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        this.renderEngine.bindTexture(locationCloudsPng);
        Vec3 color = this.theWorld.getCloudColour(partialTicks);
        float red = (float)color.xCoord;
        float green = (float)color.yCoord;
        float blue = (float)color.zCoord;
        if (this.mc.gameSettings.anaglyph) {
            float altRed = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float altGreen = (red * 30.0f + green * 70.0f) / 100.0f;
            float altBlue = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = altRed;
            green = altGreen;
            blue = altBlue;
        }
        double cloudTick = (float)this.cloudTickCounter + partialTicks;
        float cloudScale = (float)((Integer)Settings.CLOUD_SCALE.option.getStore()).intValue() * 0.25f;
        float cloudInteriorWidth = 12.0f * cloudScale;
        float cloudInteriorHeight = 4.0f * cloudScale;
        float cameraOffsetY = (float)(this.mc.renderViewEntity.lastTickPosY + (this.mc.renderViewEntity.posY - this.mc.renderViewEntity.lastTickPosY) * (double)partialTicks);
        double cameraOffsetX = (this.mc.renderViewEntity.prevPosX + (this.mc.renderViewEntity.posX - this.mc.renderViewEntity.prevPosX) * (double)partialTicks + cloudTick * 0.03) / (double)cloudInteriorWidth;
        double cameraOffsetZ = (this.mc.renderViewEntity.prevPosZ + (this.mc.renderViewEntity.posZ - this.mc.renderViewEntity.prevPosZ) * (double)partialTicks) / (double)cloudInteriorWidth + 0.33;
        cameraOffsetX -= (double)(MathHelper.floor_double((double)(cameraOffsetX / 2048.0)) * 2048);
        cameraOffsetZ -= (double)(MathHelper.floor_double((double)(cameraOffsetZ / 2048.0)) * 2048);
        float cameraRelativeY = this.theWorld.provider.getCloudHeight() - cameraOffsetY + 0.33f;
        float cameraRelativeX = (float)(cameraOffsetX - (double)MathHelper.floor_double((double)cameraOffsetX));
        float cameraRelativeZ = (float)(cameraOffsetZ - (double)MathHelper.floor_double((double)cameraOffsetZ));
        float scrollSpeed = 0.00390625f;
        float cloudScrollingX = (float)MathHelper.floor_double((double)cameraOffsetX) * scrollSpeed;
        float cloudScrollingZ = (float)MathHelper.floor_double((double)cameraOffsetZ) * scrollSpeed;
        float cloudWidth = 8.0f;
        int renderRadius = (int)((float)((Integer)Settings.RENDER_DISTANCE_CLOUDS.option.getStore()).intValue() / (cloudScale * 2.0f));
        float edgeOverlap = 1.0E-4f;
        GL11.glScalef((float)cloudInteriorWidth, (float)1.0f, (float)cloudInteriorWidth);
        for (int loop = 0; loop < 2; ++loop) {
            if (loop == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else if (this.mc.gameSettings.anaglyph) {
                if (EntityRenderer.anaglyphField == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int chunkX = -renderRadius + 1; chunkX <= renderRadius; ++chunkX) {
                for (int chunkZ = -renderRadius + 1; chunkZ <= renderRadius; ++chunkZ) {
                    tessellator.startDrawingQuads();
                    float chunkOffsetX = (float)chunkX * cloudWidth;
                    float chunkOffsetZ = (float)chunkZ * cloudWidth;
                    float startX = chunkOffsetX - cameraRelativeX;
                    float startZ = chunkOffsetZ - cameraRelativeZ;
                    if (cameraRelativeY > -cloudInteriorHeight - 1.0f) {
                        tessellator.setColorRGBA_F(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV((double)startX, (double)cameraRelativeY, (double)(startZ + cloudWidth), (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                        tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)cameraRelativeY, (double)(startZ + cloudWidth), (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                        tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)cameraRelativeY, (double)startZ, (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                        tessellator.addVertexWithUV((double)startX, (double)cameraRelativeY, (double)startZ, (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                    }
                    if (cameraRelativeY <= cloudInteriorHeight + 1.0f) {
                        tessellator.setColorRGBA_F(red, green, blue, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV((double)startX, (double)(cameraRelativeY + cloudInteriorHeight - edgeOverlap), (double)(startZ + cloudWidth), (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                        tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)(cameraRelativeY + cloudInteriorHeight - edgeOverlap), (double)(startZ + cloudWidth), (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                        tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)(cameraRelativeY + cloudInteriorHeight - edgeOverlap), (double)startZ, (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                        tessellator.addVertexWithUV((double)startX, (double)(cameraRelativeY + cloudInteriorHeight - edgeOverlap), (double)startZ, (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                    }
                    tessellator.setColorRGBA_F(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (Math.abs(chunkX) < 6 && Math.abs(chunkZ) < 6) {
                        double x;
                        float chunk;
                        if (chunkX > -1) {
                            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                            for (chunk = 0.0f; chunk < cloudWidth; chunk += 1.0f) {
                                x = startX + chunk;
                                tessellator.addVertexWithUV(x, (double)cameraRelativeY, (double)(startZ + cloudWidth), (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV(x, (double)(cameraRelativeY + cloudInteriorHeight), (double)(startZ + cloudWidth), (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV(x, (double)(cameraRelativeY + cloudInteriorHeight), (double)startZ, (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV(x, (double)cameraRelativeY, (double)startZ, (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                            }
                        }
                        if (chunkX <= 1) {
                            tessellator.setNormal(1.0f, 0.0f, 0.0f);
                            for (chunk = 0.0f; chunk < cloudWidth; chunk += 1.0f) {
                                x = startX + chunk + 1.0f - edgeOverlap;
                                tessellator.addVertexWithUV(x, (double)cameraRelativeY, (double)(startZ + cloudWidth), (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV(x, (double)(cameraRelativeY + cloudInteriorHeight), (double)(startZ + cloudWidth), (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + cloudWidth) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV(x, (double)(cameraRelativeY + cloudInteriorHeight), (double)startZ, (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV(x, (double)cameraRelativeY, (double)startZ, (double)((chunkOffsetX + chunk + 0.5f) * scrollSpeed + cloudScrollingX), (double)(chunkOffsetZ * scrollSpeed + cloudScrollingZ));
                            }
                        }
                        tessellator.setColorRGBA_F(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                        if (chunkZ > -1) {
                            tessellator.setNormal(0.0f, 0.0f, -1.0f);
                            for (chunk = 0.0f; chunk < cloudWidth; chunk += 1.0f) {
                                tessellator.addVertexWithUV((double)startX, (double)(cameraRelativeY + cloudInteriorHeight), (double)(startZ + chunk), (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)(cameraRelativeY + cloudInteriorHeight), (double)(startZ + chunk), (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)cameraRelativeY, (double)(startZ + chunk), (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV((double)startX, (double)cameraRelativeY, (double)(startZ + chunk), (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                            }
                        }
                        if (chunkZ <= 1) {
                            tessellator.setNormal(0.0f, 0.0f, 1.0f);
                            for (chunk = 0.0f; chunk < cloudWidth; chunk += 1.0f) {
                                tessellator.addVertexWithUV((double)startX, (double)(cameraRelativeY + cloudInteriorHeight), (double)(startZ + chunk + 1.0f - edgeOverlap), (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)(cameraRelativeY + cloudInteriorHeight), (double)(startZ + chunk + 1.0f - edgeOverlap), (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV((double)(startX + cloudWidth), (double)cameraRelativeY, (double)(startZ + chunk + 1.0f - edgeOverlap), (double)((chunkOffsetX + cloudWidth) * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                                tessellator.addVertexWithUV((double)startX, (double)cameraRelativeY, (double)(startZ + chunk + 1.0f - edgeOverlap), (double)(chunkOffsetX * scrollSpeed + cloudScrollingX), (double)((chunkOffsetZ + chunk + 0.5f) * scrollSpeed + cloudScrollingZ));
                            }
                        }
                    }
                    tessellator.draw();
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }

    public void renderCloudsFast(float partialTicks) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        this.renderEngine.bindTexture(locationCloudsPng);
        Vec3 color = this.theWorld.getCloudColour(partialTicks);
        float red = (float)color.xCoord;
        float green = (float)color.yCoord;
        float blue = (float)color.zCoord;
        if (this.mc.gameSettings.anaglyph) {
            float altRed = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            float altGreen = (red * 30.0f + green * 70.0f) / 100.0f;
            float altBlue = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = altRed;
            green = altGreen;
            blue = altBlue;
        }
        double cloudTick = (float)this.cloudTickCounter + partialTicks;
        float cameraOffsetY = (float)(this.mc.renderViewEntity.lastTickPosY + (this.mc.renderViewEntity.posY - this.mc.renderViewEntity.lastTickPosY) * (double)partialTicks);
        double cameraOffsetX = this.mc.renderViewEntity.prevPosX + (this.mc.renderViewEntity.posX - this.mc.renderViewEntity.prevPosX) * (double)partialTicks + cloudTick * 0.03;
        double cameraOffsetZ = this.mc.renderViewEntity.prevPosZ + (this.mc.renderViewEntity.posZ - this.mc.renderViewEntity.prevPosZ) * (double)partialTicks;
        cameraOffsetX -= (double)(MathHelper.floor_double((double)(cameraOffsetX / 2048.0)) * 2048);
        cameraOffsetZ -= (double)(MathHelper.floor_double((double)(cameraOffsetZ / 2048.0)) * 2048);
        float renderRadius = 32 * (Integer)Settings.RENDER_DISTANCE_CLOUDS.option.getStore();
        double uvScale = 5.0E-4 / (double)((Integer)Settings.CLOUD_SCALE.option.getStore()).intValue() * 0.25;
        float uvShiftX = (float)(cameraOffsetX * uvScale);
        float uvShiftZ = (float)(cameraOffsetZ * uvScale);
        double cameraRelativeY = this.theWorld.provider.getCloudHeight() - cameraOffsetY + 0.33f;
        double neg = -renderRadius;
        double pos = renderRadius;
        double startXUv = neg * uvScale + (double)uvShiftX;
        double startZUv = neg * uvScale + (double)uvShiftZ;
        double movedXUv = pos * uvScale + (double)uvShiftX;
        double movedZUv = pos * uvScale + (double)uvShiftZ;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(red, green, blue, 0.8f);
        tessellator.addVertexWithUV(neg, cameraRelativeY, pos, startXUv, movedZUv);
        tessellator.addVertexWithUV(pos, cameraRelativeY, pos, movedXUv, movedZUv);
        tessellator.addVertexWithUV(pos, cameraRelativeY, neg, movedXUv, startZUv);
        tessellator.addVertexWithUV(neg, cameraRelativeY, neg, startXUv, startZUv);
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }
}

