/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.shader;

import com.gtnewhorizons.angelica.glsm.GLDebug;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import java.util.Locale;
import net.coderbot.iris.gl.GlResource;
import net.coderbot.iris.gl.shader.ShaderType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlResource {
    private static final Logger LOGGER = LogManager.getLogger(GlShader.class);
    private final String name;

    public GlShader(ShaderType type, String name, String src) {
        super(GlShader.createShader(type, name, src));
        this.name = name;
    }

    private static int createShader(ShaderType type, String name, String src) {
        int result;
        int handle = GL20.glCreateShader((int)type.id);
        GL20.glShaderSource((int)handle, (CharSequence)(src + '\u0000'));
        GL20.glCompileShader((int)handle);
        GLDebug.nameObject(33505, handle, name + "(" + type.name().toLowerCase(Locale.ROOT) + ")");
        String log = RenderSystem.getShaderInfoLog(handle);
        if (!log.isEmpty()) {
            LOGGER.warn("Shader compilation log for " + name + ": " + log);
        }
        if ((result = GL20.glGetShaderi((int)handle, (int)35713)) != 1) {
            throw new RuntimeException("Shader compilation failed, see log for details");
        }
        return handle;
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.getGlId();
    }

    @Override
    protected void destroyInternal() {
        GL20.glDeleteShader((int)this.getGlId());
    }
}

