/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.toremove.MatrixStack;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.RenderSystem;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.shaderpack.OptionalBoolean;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shadow.ShadowMatrices;
import net.coderbot.iris.shadows.CullingDataCache;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.shadows.frustum.BoxCuller;
import net.coderbot.iris.shadows.frustum.CullEverythingFrustum;
import net.coderbot.iris.shadows.frustum.FrustumHolder;
import net.coderbot.iris.shadows.frustum.advanced.AdvancedShadowCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.BoxCullingFrustum;
import net.coderbot.iris.shadows.frustum.fallback.NonCullingFrustum;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ShadowRenderer {
    public static final Matrix4f MODELVIEW = new Matrix4f();
    public static final FloatBuffer MODELVIEW_BUFFER = BufferUtils.createFloatBuffer((int)16);
    public static final Matrix4f PROJECTION = new Matrix4f();
    public static List<TileEntity> visibleTileEntities;
    public static List<TileEntity> globalTileEntities;
    public static boolean ACTIVE;
    private final float halfPlaneLength;
    private final float renderDistanceMultiplier;
    private final float entityShadowDistanceMultiplier;
    private final int resolution;
    private final float intervalSize;
    private final Float fov;
    private final ShadowRenderTargets targets;
    private final OptionalBoolean packCullingState;
    private boolean packHasVoxelization;
    private final boolean shouldRenderTerrain;
    private final boolean shouldRenderTranslucent;
    private final boolean shouldRenderEntities;
    private final boolean shouldRenderPlayer;
    private final boolean shouldRenderBlockEntities;
    private final float sunPathRotation;
    private final List<MipmapPass> mipmapPasses = new ArrayList<MipmapPass>();
    private final String debugStringOverall;
    private FrustumHolder terrainFrustumHolder;
    private FrustumHolder entityFrustumHolder;
    private String debugStringTerrain = "(unavailable)";
    private int renderedShadowEntities = 0;
    private int renderedShadowTileEntities = 0;
    private Profiler profiler;
    private final IntBuffer swizzleBuf = BufferUtils.createIntBuffer((int)4);

    public ShadowRenderer(ProgramSource shadow, PackDirectives directives, ShadowRenderTargets shadowRenderTargets) {
        this.profiler = Minecraft.func_71410_x().field_71424_I;
        PackShadowDirectives shadowDirectives = directives.getShadowDirectives();
        this.halfPlaneLength = shadowDirectives.getDistance();
        this.renderDistanceMultiplier = shadowDirectives.getDistanceRenderMul();
        this.entityShadowDistanceMultiplier = shadowDirectives.getEntityShadowDistanceMul();
        this.resolution = shadowDirectives.getResolution();
        this.intervalSize = shadowDirectives.getIntervalSize();
        this.shouldRenderTerrain = shadowDirectives.shouldRenderTerrain();
        this.shouldRenderTranslucent = shadowDirectives.shouldRenderTranslucent();
        this.shouldRenderEntities = shadowDirectives.shouldRenderEntities();
        this.shouldRenderPlayer = shadowDirectives.shouldRenderPlayer();
        this.shouldRenderBlockEntities = shadowDirectives.shouldRenderBlockEntities();
        this.debugStringOverall = "half plane = " + this.halfPlaneLength + " meters @ " + this.resolution + "x" + this.resolution;
        this.terrainFrustumHolder = new FrustumHolder();
        this.entityFrustumHolder = new FrustumHolder();
        this.fov = shadowDirectives.getFov();
        this.targets = shadowRenderTargets;
        if (shadow != null) {
            this.packHasVoxelization = shadow.getGeometrySource().isPresent();
            this.packCullingState = shadowDirectives.getCullingState();
        } else {
            this.packHasVoxelization = false;
            this.packCullingState = OptionalBoolean.DEFAULT;
        }
        this.sunPathRotation = directives.getSunPathRotation();
        this.configureSamplingSettings(shadowDirectives);
    }

    public void setUsesImages(boolean usesImages) {
        this.packHasVoxelization = this.packHasVoxelization || usesImages;
    }

    public static MatrixStack createShadowModelView(float sunPathRotation, float intervalSize) {
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x;
        double cameraY = cameraPos.y;
        double cameraZ = cameraPos.z;
        MatrixStack modelView = new MatrixStack();
        ShadowMatrices.createModelViewMatrix(modelView, ShadowRenderer.getShadowAngle(), intervalSize, sunPathRotation, cameraX, cameraY, cameraZ);
        return modelView;
    }

    private static WorldClient getLevel() {
        return Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
    }

    private static float getSkyAngle() {
        return Minecraft.func_71410_x().field_71441_e.func_72826_c(CapturedRenderingState.INSTANCE.getTickDelta());
    }

    private static float getSunAngle() {
        float skyAngle = ShadowRenderer.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = ShadowRenderer.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private void configureSamplingSettings(PackShadowDirectives shadowDirectives) {
        ImmutableList<PackShadowDirectives.DepthSamplingSettings> depthSamplingSettings = shadowDirectives.getDepthSamplingSettings();
        ImmutableList<PackShadowDirectives.SamplingSettings> colorSamplingSettings = shadowDirectives.getColorSamplingSettings();
        GLStateManager.glActiveTexture(33988);
        this.configureDepthSampler(this.targets.getDepthTexture().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(0));
        this.configureDepthSampler(this.targets.getDepthTextureNoTranslucents().getTextureId(), (PackShadowDirectives.DepthSamplingSettings)depthSamplingSettings.get(1));
        for (int i = 0; i < colorSamplingSettings.size(); ++i) {
            int glTextureId = this.targets.get(i).getMainTexture();
            this.configureSampler(glTextureId, (PackShadowDirectives.SamplingSettings)colorSamplingSettings.get(i));
        }
        GLStateManager.glActiveTexture(33984);
    }

    private void configureDepthSampler(int glTextureId, PackShadowDirectives.DepthSamplingSettings settings) {
        if (settings.getHardwareFiltering()) {
            RenderSystem.texParameteri(glTextureId, 3553, 34892, 34894);
        }
        this.swizzleBuf.rewind();
        this.swizzleBuf.put(new int[]{6403, 6403, 6403, 1}).rewind();
        RenderSystem.texParameteriv(glTextureId, 3553, 36422, this.swizzleBuf);
        this.configureSampler(glTextureId, settings);
    }

    private void configureSampler(int glTextureId, PackShadowDirectives.SamplingSettings settings) {
        if (settings.getMipmap()) {
            int filteringMode = settings.getNearest() ? 9984 : 9987;
            this.mipmapPasses.add(new MipmapPass(glTextureId, filteringMode));
        }
        if (!settings.getNearest()) {
            RenderSystem.texParameteri(glTextureId, 3553, 10241, 9729);
            RenderSystem.texParameteri(glTextureId, 3553, 10240, 9729);
        } else {
            RenderSystem.texParameteri(glTextureId, 3553, 10241, 9728);
            RenderSystem.texParameteri(glTextureId, 3553, 10240, 9728);
        }
    }

    private void generateMipmaps() {
        GLStateManager.glActiveTexture(33988);
        for (MipmapPass mipmapPass : this.mipmapPasses) {
            this.setupMipmappingForTexture(mipmapPass.getTexture(), mipmapPass.getTargetFilteringMode());
        }
        GLStateManager.glActiveTexture(33984);
    }

    private void setupMipmappingForTexture(int texture, int filteringMode) {
        RenderSystem.generateMipmaps(texture, 3553);
        RenderSystem.texParameteri(texture, 3553, 10241, filteringMode);
    }

    private FrustumHolder createShadowFrustum(float renderMultiplier, FrustumHolder holder) {
        String reason;
        double distance;
        if ((this.packCullingState == OptionalBoolean.FALSE || this.packHasVoxelization) && this.packCullingState != OptionalBoolean.TRUE) {
            distance = this.halfPlaneLength * renderMultiplier;
            reason = this.packCullingState == OptionalBoolean.FALSE ? "(set by shader pack)" : "(voxelization detected)";
            if (distance <= 0.0 || distance > (double)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16)) {
                String distanceInfo = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 + " blocks (capped by normal render distance)";
                String cullingInfo = "disabled " + reason;
                return holder.setInfo(new NonCullingFrustum(), distanceInfo, cullingInfo);
            }
        } else {
            String cullingInfo;
            BoxCuller boxCuller;
            String distanceInfo;
            double distance2 = this.halfPlaneLength * renderMultiplier;
            String setter = "(set by shader pack)";
            if (renderMultiplier < 0.0f) {
                distance2 = IrisVideoSettings.shadowDistance * 16;
                setter = "(set by user)";
            }
            if (distance2 >= (double)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16)) {
                distanceInfo = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 + " blocks (capped by normal render distance)";
                boxCuller = null;
            } else {
                distanceInfo = distance2 + " blocks " + setter;
                if (distance2 == 0.0) {
                    cullingInfo = "no shadows rendered";
                    holder.setInfo(new CullEverythingFrustum(), distanceInfo, cullingInfo);
                }
                boxCuller = new BoxCuller(distance2);
            }
            cullingInfo = "Advanced Frustum Culling enabled";
            Vector4f shadowLightPosition = new CelestialUniforms(this.sunPathRotation).getShadowLightPositionInWorldSpace();
            Vector3f shadowLightVectorFromOrigin = new Vector3f(shadowLightPosition.x(), shadowLightPosition.y(), shadowLightPosition.z());
            shadowLightVectorFromOrigin.normalize();
            return holder.setInfo(new AdvancedShadowCullingFrustum(RenderingState.INSTANCE.getModelViewMatrix(), RenderingState.INSTANCE.getProjectionMatrix(), shadowLightVectorFromOrigin, boxCuller), distanceInfo, cullingInfo);
        }
        String distanceInfo = distance + " blocks (set by shader pack)";
        String cullingInfo = "distance only " + reason;
        BoxCuller boxCuller = new BoxCuller(distance);
        holder.setInfo(new BoxCullingFrustum(boxCuller), distanceInfo, cullingInfo);
        return holder;
    }

    private void setupGlState(Matrix4f projMatrix) {
        RenderSystem.setupProjectionMatrix(projMatrix);
        GLStateManager.disableCull();
    }

    private void restoreGlState() {
        GLStateManager.enableCull();
        RenderSystem.restoreProjectionMatrix();
    }

    private void copyPreTranslucentDepth() {
        this.profiler.func_76318_c("translucent depth copy");
        this.targets.copyPreTranslucentDepth();
    }

    private void renderEntities(EntityRenderer levelRenderer, Frustrum frustum, Object bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        int shadowEntities = 0;
        this.profiler.func_76320_a("cull");
        ArrayList<Entity> renderedEntities = new ArrayList<Entity>(32);
        for (Entity entity2 : ShadowRenderer.getLevel().field_72996_f) {
            renderedEntities.add(entity2);
        }
        this.profiler.func_76318_c("sort");
        renderedEntities.sort(Comparator.comparingInt(entity -> entity.getClass().hashCode()));
        this.profiler.func_76318_c("build geometry");
        GL11.glPushMatrix();
        MODELVIEW_BUFFER.clear().rewind();
        modelView.peek().getModel().get(MODELVIEW_BUFFER);
        GL11.glLoadMatrix((FloatBuffer)MODELVIEW_BUFFER);
        for (Entity entity2 : renderedEntities) {
            RenderManager.field_78727_a.func_147937_a(entity2, tickDelta);
            ++shadowEntities;
        }
        GL11.glPopMatrix();
        this.renderedShadowEntities = shadowEntities;
        this.profiler.func_76319_b();
    }

    private void renderPlayerEntity(EntityRenderer levelRenderer, Frustrum frustum, Object bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float tickDelta) {
        this.profiler.func_76320_a("cull");
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        this.profiler.func_76318_c("build geometry");
        int shadowEntities = 0;
        GL11.glPushMatrix();
        MODELVIEW_BUFFER.clear().rewind();
        modelView.peek().getModel().get(MODELVIEW_BUFFER);
        GL11.glLoadMatrix((FloatBuffer)MODELVIEW_BUFFER);
        if (player.field_70153_n != null) {
            RenderManager.field_78727_a.func_147937_a(player.field_70153_n, tickDelta);
            ++shadowEntities;
        }
        if (player.field_70154_o != null) {
            RenderManager.field_78727_a.func_147937_a(player.field_70154_o, tickDelta);
            ++shadowEntities;
        }
        RenderManager.field_78727_a.func_147937_a((Entity)player, tickDelta);
        GL11.glPopMatrix();
        this.renderedShadowEntities = ++shadowEntities;
        this.profiler.func_76319_b();
    }

    private void renderTileEntity(TileEntity tile, double cameraX, double cameraY, double cameraZ, float partialTicks) {
        if (tile.func_145835_a(cameraX, cameraY, cameraZ) >= tile.func_145833_n()) {
            return;
        }
        int brightness = tile.func_145831_w().func_72802_i(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)brightness % 65536.0f), (float)((float)brightness / 65536.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)tile.field_145851_c - cameraX, (double)tile.field_145848_d - cameraY, (double)tile.field_145849_e - cameraZ, partialTicks);
    }

    private void renderTileEntities(Object bufferSource, MatrixStack modelView, double cameraX, double cameraY, double cameraZ, float partialTicks, boolean hasEntityFrustum) {
        this.profiler.func_76320_a("build blockentities");
        int shadowTileEntities = 0;
        BoxCuller culler = null;
        if (hasEntityFrustum) {
            culler = new BoxCuller(this.halfPlaneLength * (this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier));
            culler.setPosition(cameraX, cameraY, cameraZ);
        }
        GL11.glPushMatrix();
        MODELVIEW_BUFFER.clear().rewind();
        modelView.peek().getModel().get(MODELVIEW_BUFFER);
        GL11.glLoadMatrix((FloatBuffer)MODELVIEW_BUFFER);
        for (TileEntity tileEntity : visibleTileEntities) {
            if (hasEntityFrustum && culler.isCulled(tileEntity.field_145851_c - 1, tileEntity.field_145848_d - 1, tileEntity.field_145849_e - 1, tileEntity.field_145851_c + 1, tileEntity.field_145848_d + 1, tileEntity.field_145849_e + 1)) continue;
            this.renderTileEntity(tileEntity, cameraX, cameraY, cameraZ, partialTicks);
            ++shadowTileEntities;
        }
        for (TileEntity tileEntity : globalTileEntities) {
            if (hasEntityFrustum && culler.isCulled(tileEntity.field_145851_c - 1, tileEntity.field_145848_d - 1, tileEntity.field_145849_e - 1, tileEntity.field_145851_c + 1, tileEntity.field_145848_d + 1, tileEntity.field_145849_e + 1)) continue;
            this.renderTileEntity(tileEntity, cameraX, cameraY, cameraZ, partialTicks);
            ++shadowTileEntities;
        }
        GLStateManager.glPopMatrix();
        this.renderedShadowTileEntities = shadowTileEntities;
        this.profiler.func_76319_b();
    }

    public void renderShadows(EntityRenderer levelRenderer, Camera playerCamera) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderGlobal rg = mc.field_71438_f;
        this.profiler = Minecraft.func_71410_x().field_71424_I;
        this.profiler.func_76318_c("shadows");
        ACTIVE = true;
        visibleTileEntities = new ArrayList<TileEntity>();
        globalTileEntities = new ArrayList<TileEntity>();
        MatrixStack modelView = ShadowRenderer.createShadowModelView(this.sunPathRotation, this.intervalSize);
        MODELVIEW.set((Matrix4fc)modelView.peek().getModel());
        Matrix4f shadowProjection = this.fov != null ? ShadowMatrices.createPerspectiveMatrix(this.fov.floatValue()) : ShadowMatrices.createOrthoMatrix(this.halfPlaneLength);
        PROJECTION.set((Matrix4fc)shadowProjection);
        this.profiler.func_76320_a("terrain_setup");
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)levelRenderer).saveState();
        }
        this.profiler.func_76320_a("initialize frustum");
        this.terrainFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier, this.terrainFrustumHolder);
        Vector3d cameraPos = CameraUniforms.getUnshiftedCameraPosition();
        double cameraX = cameraPos.x();
        double cameraY = cameraPos.y();
        double cameraZ = cameraPos.z();
        this.terrainFrustumHolder.getFrustum().func_78547_a(cameraX, cameraY, cameraZ);
        this.profiler.func_76319_b();
        mc.field_71438_f.func_72729_a((ICamera)this.terrainFrustumHolder.getFrustum(), playerCamera.getPartialTicks());
        this.profiler.func_76318_c("terrain");
        this.setupGlState(PROJECTION);
        if (this.shouldRenderTerrain) {
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            rg.func_72719_a((EntityLivingBase)mc.field_71439_g, 0, (double)playerCamera.getPartialTicks());
        }
        this.profiler.func_76318_c("entities");
        float tickDelta = CapturedRenderingState.INSTANCE.getTickDelta();
        boolean hasEntityFrustum = false;
        if (this.entityShadowDistanceMultiplier == 1.0f || this.entityShadowDistanceMultiplier < 0.0f) {
            this.entityFrustumHolder.setInfo(this.terrainFrustumHolder.getFrustum(), this.terrainFrustumHolder.getDistanceInfo(), this.terrainFrustumHolder.getCullingInfo());
        } else {
            hasEntityFrustum = true;
            this.entityFrustumHolder = this.createShadowFrustum(this.renderDistanceMultiplier * this.entityShadowDistanceMultiplier, this.entityFrustumHolder);
        }
        Frustrum entityShadowFrustum = this.entityFrustumHolder.getFrustum();
        entityShadowFrustum.func_78547_a(cameraX, cameraY, cameraZ);
        if (this.shouldRenderEntities) {
            this.renderEntities(levelRenderer, entityShadowFrustum, null, modelView, cameraX, cameraY, cameraZ, tickDelta);
        } else if (this.shouldRenderPlayer) {
            this.renderPlayerEntity(levelRenderer, entityShadowFrustum, null, modelView, cameraX, cameraY, cameraZ, tickDelta);
        }
        if (this.shouldRenderBlockEntities) {
            this.renderTileEntities(null, modelView, cameraX, cameraY, cameraZ, tickDelta, hasEntityFrustum);
        }
        this.profiler.func_76318_c("draw entities");
        this.copyPreTranslucentDepth();
        this.profiler.func_76318_c("translucent terrain");
        if (this.shouldRenderTranslucent) {
            rg.func_72719_a((EntityLivingBase)mc.field_71439_g, 1, (double)playerCamera.getPartialTicks());
        }
        this.debugStringTerrain = SodiumWorldRenderer.getInstance().getChunksDebugString();
        this.profiler.func_76318_c("generate mipmaps");
        this.generateMipmaps();
        this.profiler.func_76318_c("restore gl state");
        this.restoreGlState();
        if (levelRenderer instanceof CullingDataCache) {
            ((CullingDataCache)levelRenderer).restoreState();
        }
        ACTIVE = false;
        this.profiler.func_76319_b();
        this.profiler.func_76318_c("updatechunks");
    }

    public void addDebugText(List<String> messages) {
        messages.add("[AngelicaShaders] Shadow Maps: " + this.debugStringOverall);
        messages.add("[AngelicaShaders] Shadow Distance Terrain: " + this.terrainFrustumHolder.getDistanceInfo() + " Entity: " + this.entityFrustumHolder.getDistanceInfo());
        messages.add("[AngelicaShaders] Shadow Culling Terrain: " + this.terrainFrustumHolder.getCullingInfo() + " Entity: " + this.entityFrustumHolder.getCullingInfo());
        messages.add("[AngelicaShaders] Shadow Terrain: " + this.debugStringTerrain + (this.shouldRenderTerrain ? "" : " (no terrain) ") + (this.shouldRenderTranslucent ? "" : "(no translucent)"));
        messages.add("[AngelicaShaders] Shadow Entities: " + this.getEntitiesDebugString());
        messages.add("[AngelicaShaders] Shadow Block Entities: " + this.getTileEntitiesDebugString());
    }

    private String getEntitiesDebugString() {
        return this.shouldRenderEntities || this.shouldRenderPlayer ? this.renderedShadowEntities + "/" + Minecraft.func_71410_x().field_71441_e.field_72996_f.size() : "disabled by pack";
    }

    private String getTileEntitiesDebugString() {
        return this.shouldRenderBlockEntities ? this.renderedShadowTileEntities + "/" + Minecraft.func_71410_x().field_71441_e.field_147482_g.size() : "disabled by pack";
    }

    static {
        ACTIVE = false;
    }

    private static class MipmapPass {
        private final int texture;
        private final int targetFilteringMode;

        public MipmapPass(int texture, int targetFilteringMode) {
            this.texture = texture;
            this.targetFilteringMode = targetFilteringMode;
        }

        public int getTexture() {
            return this.texture;
        }

        public int getTargetFilteringMode() {
            return this.targetFilteringMode;
        }
    }
}

