/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.angelica.fontrenderer;

import com.gtnewhorizons.angelica.client.font.BatchingFontRenderer;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.mixins.interfaces.FontRendererAccessor;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FontRenderer.class})
public abstract class MixinFontRenderer
implements FontRendererAccessor {
    @Shadow
    private boolean randomStyle;
    @Shadow
    private boolean boldStyle;
    @Shadow
    private boolean strikethroughStyle;
    @Shadow
    private boolean underlineStyle;
    @Shadow
    private boolean italicStyle;
    @Shadow
    private int[] colorCode;
    @Shadow
    private int textColor;
    @Shadow
    private float alpha;
    @Shadow
    private float red;
    @Shadow
    private float blue;
    @Shadow
    private float green;
    @Shadow
    public Random fontRandom;
    @Shadow
    protected int[] charWidth;
    @Shadow
    private boolean unicodeFlag;
    @Shadow
    protected float posX;
    @Shadow
    protected float posY;
    @Shadow
    @Final
    private static ResourceLocation[] unicodePageLocations;
    @Shadow
    protected byte[] glyphWidth;
    @Shadow
    @Final
    protected ResourceLocation locationFontTexture;
    @Shadow
    @Final
    private TextureManager renderEngine;
    @Shadow
    private boolean bidiFlag;
    @Unique
    public BatchingFontRenderer angelica$batcher;
    @Unique
    private static final char angelica$FORMATTING_CHAR = '\u00a7';
    @Unique
    private static final float angelica$1_over_255 = 0.003921569f;

    @Shadow(remap=false)
    protected abstract void setColor(float var1, float var2, float var3, float var4);

    @Shadow
    protected abstract float renderCharAtPos(int var1, char var2, boolean var3);

    @Shadow(remap=false)
    protected abstract void doDraw(float var1);

    @Shadow
    protected abstract String bidiReorder(String var1);

    @Shadow(remap=false)
    protected abstract void bindTexture(ResourceLocation var1);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void angelica$injectBatcher(GameSettings settings, ResourceLocation fontLocation, TextureManager texManager, boolean unicodeMode, CallbackInfo ci) {
        this.angelica$batcher = new BatchingFontRenderer((FontRenderer)this, unicodePageLocations, this.charWidth, this.glyphWidth, this.colorCode, this.locationFontTexture);
    }

    @Unique
    private static boolean angelica$charInRange(char what, char fromInclusive, char toInclusive) {
        return what >= fromInclusive && what <= toInclusive;
    }

    @Inject(method={"drawString(Ljava/lang/String;IIIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    public void angelica$BatchedFontRendererDrawString(String text, int x, int y, int argb, boolean dropShadow, CallbackInfoReturnable<Integer> cir) {
        if (GLStateManager.getListMode() == 0) {
            cir.setReturnValue((Object)this.angelica$drawStringBatched(text, x, y, argb, dropShadow));
        }
    }

    @Inject(method={"renderString"}, at={@At(value="HEAD")}, cancellable=true)
    public void angelica$BatchedFontRendererRenderString(String text, int x, int y, int argb, boolean dropShadow, CallbackInfoReturnable<Integer> cir) {
        if (GLStateManager.getListMode() == 0) {
            cir.setReturnValue((Object)this.angelica$drawStringBatched(text, x, y, argb, dropShadow));
        }
    }

    @Override
    public int angelica$drawStringBatched(String text, int x, int y, int argb, boolean dropShadow) {
        if (text == null) {
            return 0;
        }
        if (this.bidiFlag) {
            text = this.bidiReorder(text);
        }
        if ((argb & 0xFC000000) == 0) {
            argb |= 0xFF000000;
        }
        this.red = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.blue = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.green = (float)(argb & 0xFF) / 255.0f;
        this.alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.posX = x;
        this.posY = y;
        return (int)this.angelica$batcher.drawString(x, y, argb, dropShadow, this.unicodeFlag, text, 0, text.length());
    }

    @Override
    public BatchingFontRenderer angelica$getBatcher() {
        return this.angelica$batcher;
    }

    @Override
    public void angelica$bindTexture(ResourceLocation location) {
        this.bindTexture(location);
    }

    @ModifyConstant(method={"getCharWidth"}, constant={@Constant(intValue=7)})
    private int angelica$maxCharWidth(int original) {
        return Integer.MAX_VALUE;
    }
}

