/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat;

import com.falsepattern.chunk.api.DataRegistry;
import com.gtnewhorizons.angelica.compat.ModStatus;
import com.gtnewhorizons.neid.mixins.interfaces.IExtendedBlockStorageMixin;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import ru.fewizz.idextender.Hooks;

public class ExtendedBlockStorageExt
extends ExtendedBlockStorage {
    public boolean hasSky;

    public ExtendedBlockStorageExt(int yBase, boolean hasSky) {
        super(yBase, hasSky);
        this.hasSky = hasSky;
    }

    public ExtendedBlockStorageExt(Chunk chunk, ExtendedBlockStorage storage) {
        super(storage.yBase, storage.getSkylightArray() != null);
        if (ModStatus.isChunkAPILoaded) {
            if (storage.getSkylightArray() != null) {
                this.hasSky = true;
            }
            DataRegistry.cloneSubChunk((Chunk)chunk, (ExtendedBlockStorage)storage, (ExtendedBlockStorage)this);
        } else {
            int arrayLen;
            if (ModStatus.isNEIDLoaded) {
                short[] block16BArray = ((IExtendedBlockStorageMixin)this).getBlock16BArray();
                System.arraycopy(((IExtendedBlockStorageMixin)storage).getBlock16BArray(), 0, block16BArray, 0, block16BArray.length);
                if (storage.getBlockMSBArray() != null) {
                    this.setBlockMSBArray(new NibbleArray(block16BArray.length, 4));
                    ExtendedBlockStorageExt.copyNibbleArray(storage.getBlockMSBArray(), this.getBlockMSBArray());
                }
                arrayLen = block16BArray.length;
                if (ModStatus.isNEIDMetadataExtended) {
                    short[] block16BMetaArray = ((IExtendedBlockStorageMixin)this).getBlock16BMetaArray();
                    System.arraycopy(((IExtendedBlockStorageMixin)storage).getBlock16BMetaArray(), 0, block16BMetaArray, 0, block16BMetaArray.length);
                }
            } else if (ModStatus.isOldNEIDLoaded) {
                short[] blockLSBArray = Hooks.get((ExtendedBlockStorage)this);
                System.arraycopy(Hooks.get((ExtendedBlockStorage)storage), 0, blockLSBArray, 0, blockLSBArray.length);
                arrayLen = blockLSBArray.length;
            } else {
                byte[] blockLSBArray = this.getBlockLSBArray();
                System.arraycopy(storage.getBlockLSBArray(), 0, blockLSBArray, 0, blockLSBArray.length);
                if (storage.getBlockMSBArray() != null) {
                    this.setBlockMSBArray(new NibbleArray(blockLSBArray.length, 4));
                    ExtendedBlockStorageExt.copyNibbleArray(storage.getBlockMSBArray(), this.getBlockMSBArray());
                }
                arrayLen = blockLSBArray.length;
            }
            if (!ModStatus.isNEIDMetadataExtended) {
                ExtendedBlockStorageExt.copyNibbleArray(storage.getMetadataArray(), this.getMetadataArray());
            }
            ExtendedBlockStorageExt.copyNibbleArray(storage.getBlocklightArray(), this.getBlocklightArray());
            if (storage.getSkylightArray() != null) {
                this.hasSky = true;
                if (this.getSkylightArray() == null) {
                    this.setSkylightArray(new NibbleArray(arrayLen, 4));
                }
                ExtendedBlockStorageExt.copyNibbleArray(storage.getSkylightArray(), this.getSkylightArray());
            }
        }
        this.blockRefCount = storage.blockRefCount;
    }

    private static void copyNibbleArray(NibbleArray srcArray, NibbleArray dstArray) {
        if (srcArray == null || dstArray == null) {
            throw new RuntimeException("NibbleArray is null src: " + (srcArray == null) + " dst: " + (dstArray == null));
        }
        byte[] data = srcArray.data;
        System.arraycopy(data, 0, dstArray.data, 0, data.length);
    }
}

