/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.angelica.dynamiclights;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.blockpos.IBlockPos;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import com.gtnewhorizons.angelica.dynamiclights.IDynamicLightSource;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IDynamicLightSource {
    @Shadow
    public World worldObj;
    @Shadow
    public double posX;
    @Shadow
    public double posY;
    @Shadow
    public double posZ;
    @Shadow
    public int chunkCoordX;
    @Shadow
    public int chunkCoordZ;
    @Shadow
    public boolean isDead;
    @Unique
    protected int angelica$luminance = 0;
    @Unique
    private int angelica$lastLuminance = 0;
    @Unique
    private static long angelica$lastUpdate = 0L;
    @Unique
    private double angelica$prevX;
    @Unique
    private double angelica$prevY;
    @Unique
    private double angelica$prevZ;
    @Unique
    private LongOpenHashSet angelica$trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract float getEyeHeight();

    @Override
    public double angelica$getDynamicLightX() {
        return this.posX;
    }

    @Override
    public double angelica$getDynamicLightY() {
        return this.posY + (double)this.getEyeHeight();
    }

    @Override
    public double angelica$getDynamicLightZ() {
        return this.posZ;
    }

    @Override
    public void angelica$resetDynamicLight() {
        this.angelica$lastLuminance = 0;
    }

    @Inject(method={"onEntityUpdate"}, at={@At(value="TAIL")})
    public void angelica$onUpdate(CallbackInfo ci) {
        if (this.worldObj != null && this.worldObj.isRemote) {
            if (this.isDead) {
                this.angelica$setDynamicLightEnabled(false);
            } else {
                this.angelica$dynamicLightTick();
                DynamicLights.updateTracking(this);
            }
        }
    }

    @Override
    public void angelica$dynamicLightTick() {
        this.angelica$luminance = DynamicLights.getLuminanceFromEntity((Entity)this);
    }

    @Override
    public int angelica$getLuminance() {
        return this.angelica$luminance;
    }

    @Override
    public boolean angelica$updateDynamicLight(@NotNull SodiumWorldRenderer renderer) {
        double deltaX = this.posX - this.angelica$prevX;
        double deltaY = this.posY - this.angelica$prevY;
        double deltaZ = this.posZ - this.angelica$prevZ;
        int luminance = this.angelica$getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.angelica$lastLuminance) {
            this.angelica$prevX = this.posX;
            this.angelica$prevY = this.posY;
            this.angelica$prevZ = this.posZ;
            this.angelica$lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                BlockPos chunkPos = new BlockPos(this.chunkCoordX, MathHelper.floor_double((double)(this.posY + (double)this.getEyeHeight())) >> 4, this.chunkCoordZ);
                DynamicLights.scheduleChunkRebuild(renderer, (IBlockPos)chunkPos);
                DynamicLights.updateTrackedChunks((IBlockPos)chunkPos, this.angelica$trackedLitChunkPos, newPos);
                ForgeDirection directionX = (MathHelper.floor_double((double)this.posX) & 0xF) >= 8 ? ForgeDirection.EAST : ForgeDirection.WEST;
                ForgeDirection directionY = (MathHelper.floor_double((double)(this.posY + (double)this.getEyeHeight())) & 0xF) >= 8 ? ForgeDirection.UP : ForgeDirection.DOWN;
                ForgeDirection directionZ = (MathHelper.floor_double((double)this.posZ) & 0xF) >= 8 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos = chunkPos.offset(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos = chunkPos.offset(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos = chunkPos.offset(directionX.getOpposite());
                    } else {
                        chunkPos = chunkPos.offset(directionZ.getOpposite());
                        chunkPos = chunkPos.offset(directionY);
                    }
                    DynamicLights.scheduleChunkRebuild(renderer, (IBlockPos)chunkPos);
                    DynamicLights.updateTrackedChunks((IBlockPos)chunkPos, this.angelica$trackedLitChunkPos, newPos);
                }
            }
            this.angelica$scheduleTrackedChunksRebuild(renderer);
            this.angelica$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void angelica$scheduleTrackedChunksRebuild(@NotNull SodiumWorldRenderer renderer) {
        LongIterator longIterator = this.angelica$trackedLitChunkPos.iterator();
        while (longIterator.hasNext()) {
            long pos = (Long)longIterator.next();
            DynamicLights.scheduleChunkRebuild(renderer, pos);
        }
    }
}

