/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.notfine.faceculling;

import jss.notfine.util.IFaceObstructionCheckHelper;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Block.class})
public abstract class MixinBlock {
    @Shadow
    protected double minX;
    @Shadow
    protected double minY;
    @Shadow
    protected double minZ;
    @Shadow
    protected double maxX;
    @Shadow
    protected double maxY;
    @Shadow
    protected double maxZ;

    @Overwrite
    public boolean shouldSideBeRendered(IBlockAccess worldIn, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                if (!(this.minY > 0.0)) break;
                return true;
            }
            case 1: {
                if (!(this.maxY < 1.0)) break;
                return true;
            }
            case 2: {
                if (!(this.minZ > 0.0)) break;
                return true;
            }
            case 3: {
                if (!(this.maxZ < 1.0)) break;
                return true;
            }
            case 4: {
                if (!(this.minX > 0.0)) break;
                return true;
            }
            case 5: {
                if (!(this.maxX < 1.0)) break;
                return true;
            }
        }
        Block otherBlock = worldIn.getBlock(x, y, z);
        if (otherBlock.isOpaqueCube()) {
            return false;
        }
        if (otherBlock instanceof IFaceObstructionCheckHelper) {
            IFaceObstructionCheckHelper target = (IFaceObstructionCheckHelper)otherBlock;
            return target.isFaceNonObstructing(worldIn, x, y, z, side, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return true;
    }
}

