/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.zoom;

import com.gtnewhorizons.angelica.zoom.IMouseFilterExt;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;

public class Zoom {
    public static final float ZOOM_MIN = 1.0f;
    public static final float ZOOM_MAX = 64.0f;
    public static final float ZOOM_STEP = 1.2f;
    public static final float ZOOM_DEFAULT = 4.0f;
    private static float zoom = 4.0f;
    private static final KeyBinding zoomKey = new KeyBinding("Zoom", 0, "key.categories.misc");
    private static boolean zoomEnabled = false;

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyBinding)zoomKey);
        FMLCommonHandler.instance().bus().register((Object)new Zoom());
    }

    public static boolean isZoomedIn() {
        return zoomEnabled;
    }

    public static void modifyZoom(int eventDWheel) {
        if (eventDWheel == 0) {
            return;
        }
        zoom = MathHelper.clamp_float((float)((float)((double)zoom * Math.pow(1.2f, Integer.signum(eventDWheel)))), (float)1.0f, (float)64.0f);
    }

    private static void resetMouseFilters(Minecraft mc) {
        ((IMouseFilterExt)mc.entityRenderer.mouseFilterXAxis).angelica$reset();
        ((IMouseFilterExt)mc.entityRenderer.mouseFilterYAxis).angelica$reset();
    }

    public static void resetZoom() {
        Minecraft mc = Minecraft.getMinecraft();
        zoomEnabled = false;
        zoom = 4.0f;
        Zoom.resetMouseFilters(mc);
    }

    private void handleKeyEvent() {
        if (zoomKey.getKeyCode() == 0) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.currentScreen != null) {
            return;
        }
        if (zoomKey.getIsKeyPressed()) {
            zoomEnabled = true;
        } else if (zoomEnabled) {
            Zoom.resetZoom();
        }
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.KeyInputEvent e) {
        this.handleKeyEvent();
    }

    @SubscribeEvent
    public void onMouseKeyPress(InputEvent.MouseInputEvent e) {
        if (Mouse.getEventButton() >= 0) {
            this.handleKeyEvent();
        }
    }

    @Generated
    public static float getZoom() {
        return zoom;
    }

    @Generated
    public static KeyBinding getZoomKey() {
        return zoomKey;
    }
}

