/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import jss.notfine.gui.GuiCustomMenuButton;
import jss.notfine.gui.options.control.element.NotFineControlElementFactory;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;

@SideOnly(value=Side.CLIENT)
public class GuiCustomOptionsRowList
extends GuiListExtended {
    private static final NotFineControlElementFactory factory = new NotFineControlElementFactory();
    private final List<Row> settingsList = Lists.newArrayList();

    public GuiCustomOptionsRowList(Minecraft mc, int width, int height, int top, int bottom, int slotHeight, OptionPage optionPage, OptionPage ... subPages) {
        super(mc, width, height, top, bottom, slotHeight);
        this.field_148163_i = false;
        for (OptionGroup optionGroup : optionPage.getGroups()) {
            Iterator settings = optionGroup.getOptions().stream().iterator();
            while (settings.hasNext()) {
                Option optionOne = (Option)settings.next();
                Option optionTwo = settings.hasNext() ? (Option)settings.next() : null;
                GuiButton buttonOne = (GuiButton)optionOne.getControl().createElement(new Dim2i(width / 2 - 155, 0, 150, 20), factory);
                GuiButton buttonTwo = optionTwo == null ? null : (GuiButton)optionTwo.getControl().createElement(new Dim2i(width / 2 - 155 + 160, 0, 150, 20), factory);
                this.settingsList.add(new Row(buttonOne, buttonTwo));
            }
        }
        for (int i = 0; i < subPages.length; i += 2) {
            OptionPage pageOne = subPages[i];
            OptionPage pageTwo = i < subPages.length - 1 ? subPages[i + 1] : null;
            GuiCustomMenuButton buttonOne = new GuiCustomMenuButton(width / 2 - 155, 0, pageOne, new OptionPage[0]);
            GuiCustomMenuButton buttonTwo = pageTwo == null ? null : new GuiCustomMenuButton(width / 2 - 155 + 160, 0, pageTwo, new OptionPage[0]);
            this.settingsList.add(new Row(buttonOne, buttonTwo));
        }
    }

    public Row getListEntry(int index) {
        return this.settingsList.get(index);
    }

    protected int getSize() {
        return this.settingsList.size();
    }

    public int getListWidth() {
        return 400;
    }

    protected int getScrollBarX() {
        return super.getScrollBarX() + 32;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Row
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft mc = Minecraft.getMinecraft();
        private final GuiButton buttonOne;
        private final GuiButton buttonTwo;

        public Row(GuiButton one, GuiButton two) {
            this.buttonOne = one;
            this.buttonTwo = two;
            if (one != null && two == null) {
                one.width += 160;
            }
        }

        public void drawEntry(int varU1, int x, int y, int varU2, int varU3, Tessellator tessellator, int mouseX, int mouseY, boolean varU4) {
            this.buttonOne.yPosition = y;
            this.buttonOne.drawButton(this.mc, mouseX, mouseY);
            if (this.buttonTwo != null) {
                this.buttonTwo.yPosition = y;
                this.buttonTwo.drawButton(this.mc, mouseX, mouseY);
            }
        }

        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.buttonOne.mousePressed(this.mc, x, y)) {
                return true;
            }
            return this.buttonTwo != null && this.buttonTwo.mousePressed(this.mc, x, y);
        }

        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.buttonOne != null) {
                this.buttonOne.mouseReleased(x, y);
            }
            if (this.buttonTwo != null) {
                this.buttonTwo.mouseReleased(x, y);
            }
        }
    }
}

