/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.gui.options.control.element;

import java.util.Collection;
import jss.notfine.gui.GuiCustomMenu;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.EnumChatFormatting;

public class NotFineControlElement<T>
extends GuiButton
implements ControlElement<T> {
    protected final Option<T> option;
    protected final Dim2i dim;

    public NotFineControlElement(Option<T> option, Dim2i dim) {
        super(-5, dim.getOriginX(), dim.getOriginY(), dim.getWidth(), dim.getHeight(), option.getName());
        this.option = option;
        this.dim = dim;
        this.enabled = option.isAvailable();
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        this.displayString = this.getLabel();
        super.drawButton(mc, mouseX, mouseY);
    }

    public String getLabel() {
        String name = this.option.getName();
        this.enabled = this.option.isAvailable();
        String label = this.enabled && this.option.hasChanged() ? EnumChatFormatting.ITALIC + name : name;
        label = label + ": ";
        return label;
    }

    protected void onOptionValueChanged() {
        this.option.applyChanges();
        Collection<OptionFlag> flags = this.option.getFlags();
        Minecraft mc = Minecraft.getMinecraft();
        if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
            mc.renderGlobal.loadRenderers();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            mc.getTextureMapBlocks().setMipmapLevels(mc.gameSettings.mipmapLevels);
            mc.refreshResources();
        }
        GuiCustomMenu.dirtyStorages.add(this.option.getStorage());
    }

    @Override
    public boolean isHovered() {
        return false;
    }

    @Override
    public Option<T> getOption() {
        return this.option;
    }

    @Override
    public Dim2i getDimensions() {
        return this.dim;
    }
}

