/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.shader.GlShader;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ShaderLoader {
    public static GlShader loadShader(RenderDevice device, ShaderType type, ResourceLocation name, ShaderConstants constants) {
        return new GlShader(device, type, name, ShaderLoader.getShaderSource(ShaderLoader.getShaderPath(name, type)), constants);
    }

    @Deprecated
    public static GlShader loadShader(RenderDevice device, ShaderType type, ResourceLocation name, List<String> constants) {
        return new GlShader(device, type, name, ShaderLoader.getShaderSource(ShaderLoader.getShaderPath(name, type)), ShaderConstants.fromStringList(constants));
    }

    public static String getShaderPath(ResourceLocation name, ShaderType type) {
        return String.format("/assets/%s/shaders/%s.%s.glsl", name.getResourceDomain(), name.getResourcePath(), type == ShaderType.VERTEX ? "v" : "f");
    }

    private static String getShaderSource(String path) {
        String string;
        block9: {
            InputStream in = ShaderLoader.class.getResourceAsStream(path);
            try {
                if (in == null) {
                    throw new RuntimeException("Shader not found: " + path);
                }
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read shader sources", e);
                }
            }
            in.close();
        }
        return string;
    }
}

