/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.screen;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.ShaderPackOptionList;
import net.coderbot.iris.gui.element.ShaderPackSelectionList;
import net.coderbot.iris.gui.element.shaderselection.ShaderPackEntry;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.CommentedElementWidget;
import net.coderbot.iris.gui.element.widget.IrisButton;
import net.coderbot.iris.gui.element.widget.IrisImageButton;
import net.coderbot.iris.gui.screen.HudHideable;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;

public class ShaderPackScreen
extends GuiScreen
implements HudHideable {
    public static final Set<Runnable> TOP_LAYER_RENDER_QUEUE = new HashSet<Runnable>();
    private static final String SELECT_TITLE = I18n.format((String)"pack.iris.select.title", (Object[])new Object[0]);
    private static final String CONFIGURE_TITLE = I18n.format((String)"pack.iris.configure.title", (Object[])new Object[0]);
    private static final int COMMENT_PANEL_WIDTH = 314;
    private final GuiScreen parent;
    private final String title;
    private final String irisTextComponent;
    private ShaderPackSelectionList shaderPackList;
    @Nullable
    private ShaderPackOptionList shaderOptionList = null;
    @Nullable
    private NavigationController navigation = null;
    private GuiButton screenSwitchButton;
    private String notificationDialog = null;
    private int notificationDialogTimer = 0;
    @Nullable
    private AbstractElementWidget<?> hoveredElement = null;
    private Optional<String> hoveredElementCommentTitle = Optional.empty();
    private List<String> hoveredElementCommentBody = new ArrayList<String>();
    private int hoveredElementCommentTimer = 0;
    private boolean optionMenuOpen = false;
    private boolean dropChanges = false;
    private String developmentComponent;
    private String updateComponent;
    private boolean guiHidden = false;
    private boolean dirty = false;
    private float guiButtonHoverTimer = 0.0f;

    public ShaderPackScreen(GuiScreen parent) {
        this.title = I18n.format((String)"options.iris.shaderPackSelection.title", (Object[])new Object[0]);
        this.parent = parent;
        String irisName = "AngelicaShaders";
        if (Iris.INSTANCE.isDevelopmentEnvironment) {
            this.developmentComponent = "Development Environment";
            irisName = irisName.replace("-development-environment", "");
        }
        this.irisTextComponent = irisName;
        this.refreshForChangedPack();
    }

    public void drawScreen(int mouseX, int mouseY, float delta) {
        GLStateManager.glPushAttrib(16384);
        if (this.dirty) {
            this.dirty = false;
            this.initGui();
        }
        if (this.mc.theWorld == null) {
            super.drawDefaultBackground();
        } else if (!this.guiHidden) {
            this.drawGradientRect(0, 0, this.width, this.height, 1327702819, 1327702819);
        }
        if (!this.guiHidden) {
            if (this.optionMenuOpen && this.shaderOptionList != null) {
                this.shaderOptionList.drawScreen(mouseX, mouseY, delta);
            } else {
                this.shaderPackList.drawScreen(mouseX, mouseY, delta);
            }
        }
        this.hoveredElementCommentTimer = this.hoveredElement != null ? ++this.hoveredElementCommentTimer : 0;
        float previousHoverTimer = this.guiButtonHoverTimer;
        super.drawScreen(mouseX, mouseY, delta);
        if (previousHoverTimer == this.guiButtonHoverTimer) {
            this.guiButtonHoverTimer = 0.0f;
        }
        if (!this.guiHidden) {
            this.drawCenteredString(this.fontRendererObj, this.title, (int)((double)this.width * 0.5), 8, 0xFFFFFF);
            if (this.notificationDialog != null && this.notificationDialogTimer > 0) {
                this.drawCenteredString(this.fontRendererObj, this.notificationDialog, (int)((double)this.width * 0.5), 21, 0xFFFFFF);
            } else if (this.optionMenuOpen) {
                this.drawCenteredString(this.fontRendererObj, CONFIGURE_TITLE, (int)((double)this.width * 0.5), 21, 0xFFFFFF);
            } else {
                this.drawCenteredString(this.fontRendererObj, SELECT_TITLE, (int)((double)this.width * 0.5), 21, 0xFFFFFF);
            }
            if (this.isDisplayingComment()) {
                int y;
                int panelHeight = Math.max(50, 18 + this.hoveredElementCommentBody.size() * 10);
                int x = mouseX + 5;
                if (x + 314 >= this.width - 4) {
                    x = this.width - 318;
                }
                if ((y = mouseY + 8) + panelHeight >= this.height - 4) {
                    y = this.height - (panelHeight + 4);
                }
                GuiUtil.drawPanel(x, y, 314, panelHeight);
                this.fontRendererObj.drawStringWithShadow(this.hoveredElementCommentTitle.orElse(""), x + 4, y + 4, 0xFFFFFF);
                for (int i = 0; i < this.hoveredElementCommentBody.size(); ++i) {
                    this.fontRendererObj.drawStringWithShadow(this.hoveredElementCommentBody.get(i), x + 4, y + 16 + i * 10, 0xFFFFFF);
                }
            }
        }
        for (Runnable render : TOP_LAYER_RENDER_QUEUE) {
            render.run();
        }
        TOP_LAYER_RENDER_QUEUE.clear();
        if (this.developmentComponent != null) {
            this.fontRendererObj.drawStringWithShadow(this.developmentComponent, 2, this.height - 10, 0xFFFFFF);
            this.fontRendererObj.drawStringWithShadow(this.irisTextComponent, 2, this.height - 20, 0xFFFFFF);
        } else if (this.updateComponent != null) {
            this.fontRendererObj.drawStringWithShadow(this.updateComponent, 2, this.height - 10, 0xFFFFFF);
            this.fontRendererObj.drawStringWithShadow(this.irisTextComponent, 2, this.height - 20, 0xFFFFFF);
        } else {
            this.fontRendererObj.drawStringWithShadow(this.irisTextComponent, 2, this.height - 10, 0xFFFFFF);
        }
        GLStateManager.glPopAttrib();
    }

    public void initGui() {
        super.initGui();
        int bottomCenter = this.width / 2 - 50;
        int topCenter = this.width / 2 - 76;
        boolean inWorld = this.mc.theWorld != null;
        this.shaderPackList = new ShaderPackSelectionList(this, this.mc, this.width, this.height, 32, this.height - 58, 0, this.width);
        if (Iris.getCurrentPack().isPresent() && this.navigation != null) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.shaderOptionList = new ShaderPackOptionList(this, this.navigation, currentPack, this.mc, this.width, this.height, 32, this.height - 58, 0, this.width);
            this.navigation.setActiveOptionList(this.shaderOptionList);
            this.shaderOptionList.rebuild();
        } else {
            this.optionMenuOpen = false;
            this.shaderOptionList = null;
        }
        if (inWorld) {
            this.shaderPackList.setRenderBackground(false);
            if (this.shaderOptionList != null) {
                this.shaderOptionList.setRenderBackground(false);
            }
        }
        this.buttonList.clear();
        if (!this.guiHidden) {
            this.buttonList.add(new IrisButton(bottomCenter + 104, this.height - 27, 100, 20, I18n.format((String)"gui.done", (Object[])new Object[0]), button -> this.onClose()));
            this.buttonList.add(new IrisButton(bottomCenter, this.height - 27, 100, 20, I18n.format((String)"options.iris.apply", (Object[])new Object[0]), button -> this.applyChanges()));
            this.buttonList.add(new IrisButton(bottomCenter - 104, this.height - 27, 100, 20, I18n.format((String)"gui.cancel", (Object[])new Object[0]), button -> this.dropChangesAndClose()));
            this.buttonList.add(new IrisButton(topCenter - 78, this.height - 51, 152, 20, I18n.format((String)"options.iris.openShaderPackFolder", (Object[])new Object[0]), button -> this.openShaderPackFolder()));
            this.screenSwitchButton = new IrisButton(topCenter + 78, this.height - 51, 152, 20, I18n.format((String)"options.iris.shaderPackList", (Object[])new Object[0]), button -> {
                this.optionMenuOpen = !this.optionMenuOpen;
                this.applyChanges();
                this.initGui();
            });
            this.buttonList.add(this.screenSwitchButton);
            this.refreshScreenSwitchButton();
        }
        if (inWorld) {
            float endOfLastButton = (float)this.width / 2.0f + 154.0f;
            float freeSpace = (float)this.width - endOfLastButton;
            int x = freeSpace > 100.0f ? this.width - 50 : (freeSpace < 20.0f ? this.width - 20 : (int)(endOfLastButton + freeSpace / 2.0f) - 10);
            this.buttonList.add(new IrisImageButton(x, this.height - 39, 20, 20, this.guiHidden ? 20 : 0, 146, 20, GuiUtil.IRIS_WIDGETS_TEX, button -> {
                this.guiHidden = !this.guiHidden;
                this.dirty = true;
            }));
        }
        this.hoveredElement = null;
        this.hoveredElementCommentTimer = 0;
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean handled = false;
        if (!this.guiHidden) {
            handled = this.optionMenuOpen && this.shaderOptionList != null ? this.shaderOptionList.mouseClicked(mouseX, mouseY, mouseButton) : this.shaderPackList.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (!handled) {
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        boolean handled = false;
        if (!this.guiHidden && state != -1) {
            handled = this.optionMenuOpen && this.shaderOptionList != null ? this.shaderOptionList.mouseReleased(mouseX, mouseY, Mouse.getEventButton()) : this.shaderPackList.mouseReleased(mouseX, mouseY, Mouse.getEventButton());
        }
        if (!handled) {
            super.mouseMovedOrUp(mouseX, mouseY, state);
        }
    }

    protected void actionPerformed(GuiButton guiButton) {
        if (guiButton.enabled && guiButton instanceof IrisButton) {
            IrisButton irisButton = (IrisButton)guiButton;
            irisButton.onPress();
        }
    }

    public void refreshForChangedPack() {
        if (Iris.getCurrentPack().isPresent()) {
            ShaderPack currentPack = Iris.getCurrentPack().get();
            this.navigation = new NavigationController();
            if (this.shaderOptionList != null) {
                this.shaderOptionList.applyShaderPack(currentPack);
                this.shaderOptionList.rebuild();
            }
        } else {
            this.navigation = null;
        }
        this.refreshScreenSwitchButton();
    }

    public void refreshScreenSwitchButton() {
        if (this.screenSwitchButton != null) {
            this.screenSwitchButton.displayString = this.optionMenuOpen ? I18n.format((String)"options.iris.shaderPackList", (Object[])new Object[0]) : I18n.format((String)"options.iris.shaderPackSettings", (Object[])new Object[0]);
            this.screenSwitchButton.enabled = this.optionMenuOpen || this.shaderPackList.getTopButtonRow().shadersEnabled;
        }
    }

    protected void keyTyped(char typedChar, int keyCode) {
        if (keyCode == 1) {
            if (this.guiHidden) {
                this.guiHidden = false;
                this.initGui();
                return;
            }
            if (this.navigation != null && this.navigation.hasHistory()) {
                this.navigation.back();
                return;
            }
            if (this.optionMenuOpen) {
                this.optionMenuOpen = false;
                this.initGui();
                return;
            }
        }
        super.keyTyped(typedChar, keyCode);
    }

    public void displayNotification(String String2) {
        this.notificationDialog = String2;
        this.notificationDialogTimer = 100;
    }

    public void onClose() {
        if (!this.dropChanges) {
            this.applyChanges();
        } else {
            this.discardChanges();
        }
        this.mc.displayGuiScreen(this.parent);
    }

    private void dropChangesAndClose() {
        this.dropChanges = true;
        this.onClose();
    }

    public void applyChanges() {
        ShaderPackEntry entry = this.shaderPackList.getSelected();
        if (entry == null) {
            return;
        }
        this.shaderPackList.setApplied(entry);
        String name = entry.getPackName();
        if (!name.equals(Iris.getCurrentPackName())) {
            Iris.clearShaderPackOptionQueue();
        }
        boolean enabled = this.shaderPackList.getTopButtonRow().shadersEnabled;
        String previousPackName = Iris.getIrisConfig().getShaderPackName().orElse(null);
        boolean previousShadersEnabled = Iris.getIrisConfig().areShadersEnabled();
        if (!name.equals(previousPackName) || enabled != previousShadersEnabled || !Iris.getShaderPackOptionQueue().isEmpty() || Iris.shouldResetShaderPackOptionsOnNextReload()) {
            Iris.getIrisConfig().setShaderPackName(name);
            IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
        }
        this.refreshForChangedPack();
    }

    private void discardChanges() {
        Iris.clearShaderPackOptionQueue();
    }

    private void openShaderPackFolder() {
        CompletableFuture.runAsync(() -> this.openUri(Iris.getShaderpacksDirectoryManager().getDirectoryUri()));
    }

    private void openUri(URI uri) {
        switch (Util.getOSType()) {
            case OSX: {
                try {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", uri.toString()});
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case WINDOWS: {
                try {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()});
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case LINUX: {
                try {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", uri.toString()});
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        boolean openViaSystemClass = false;
        try {
            Class<?> aClass = Class.forName("java.awt.Desktop");
            Object getDesktop = aClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            aClass.getMethod("browse", URI.class).invoke(getDesktop, uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            openViaSystemClass = true;
        }
        if (openViaSystemClass) {
            AngelicaTweaker.LOGGER.debug("Opening via system class!");
            Sys.openURL((String)("file://" + uri));
        }
    }

    public void setElementHoveredStatus(AbstractElementWidget<?> widget, boolean hovered) {
        if (hovered && widget != this.hoveredElement) {
            this.hoveredElement = widget;
            if (widget instanceof CommentedElementWidget) {
                this.hoveredElementCommentTitle = ((CommentedElementWidget)widget).getCommentTitle();
                Optional<String> commentBody = ((CommentedElementWidget)widget).getCommentBody();
                if (!commentBody.isPresent()) {
                    this.hoveredElementCommentBody.clear();
                } else {
                    String rawCommentBody = commentBody.get();
                    if (rawCommentBody.endsWith(".")) {
                        rawCommentBody = rawCommentBody.substring(0, rawCommentBody.length() - 1);
                    }
                    List splitByPeriods = Arrays.stream(rawCommentBody.split("\\. [ ]*")).map(String::new).collect(Collectors.toList());
                    this.hoveredElementCommentBody = new ArrayList<String>();
                    for (String text : splitByPeriods) {
                        this.hoveredElementCommentBody.addAll(this.fontRendererObj.listFormattedStringToWidth(text, 306));
                    }
                }
            } else {
                this.hoveredElementCommentTitle = Optional.empty();
                this.hoveredElementCommentBody.clear();
            }
            this.hoveredElementCommentTimer = 0;
        } else if (!hovered && widget == this.hoveredElement) {
            this.hoveredElement = null;
            this.hoveredElementCommentTitle = Optional.empty();
            this.hoveredElementCommentBody.clear();
            this.hoveredElementCommentTimer = 0;
        }
    }

    public boolean isDisplayingComment() {
        return this.hoveredElementCommentTimer > 20 && this.hoveredElementCommentTitle.isPresent() && !this.hoveredElementCommentBody.isEmpty();
    }

    public void drawCenteredString(String text, int x, int y, int color) {
        this.drawCenteredString(this.fontRendererObj, text, x, y, color);
    }

    public void drawString(String text, int x, int y, int color) {
        this.drawString(this.fontRendererObj, text, x, y, color);
    }

    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }
}

