/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.mojang.InteractionHand;
import com.gtnewhorizons.angelica.compat.toremove.RenderLayer;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import java.nio.FloatBuffer;
import java.util.Map;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    private boolean ACTIVE;
    private boolean renderingSolid;
    public static final float DEPTH = 0.125f;

    private void setupGlState(RenderGlobal gameRenderer, Camera camera, float tickDelta) {
        Minecraft mc = Minecraft.getMinecraft();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)0.125f);
        if (mc.entityRenderer.cameraZoom != 1.0) {
            GL11.glTranslatef((float)((float)mc.entityRenderer.cameraYaw), (float)((float)(-mc.entityRenderer.cameraPitch)), (float)0.0f);
            GL11.glScaled((double)mc.entityRenderer.cameraZoom, (double)mc.entityRenderer.cameraZoom, (double)1.0);
        }
        Project.gluPerspective((float)mc.entityRenderer.getFOVModifier(tickDelta, false), (float)((float)mc.displayWidth / (float)mc.displayHeight), (float)0.05f, (float)(mc.entityRenderer.farPlaneDistance * 2.0f));
        if (mc.playerController.enableEverythingIsScrewedUpMode()) {
            GL11.glScalef((float)1.0f, (float)0.6666667f, (float)1.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        mc.entityRenderer.hurtCameraEffect(tickDelta);
        if (mc.gameSettings.viewBobbing) {
            mc.entityRenderer.setupViewBobbing(tickDelta);
        }
    }

    private boolean canRender(Camera camera, RenderGlobal gameRenderer) {
        Minecraft mc = Minecraft.getMinecraft();
        return mc.entityRenderer.debugViewDirection <= 0 && mc.gameSettings.thirdPersonView == 0 && !camera.getEntity().isPlayerSleeping() && !mc.gameSettings.hideGUI && !mc.playerController.enableEverythingIsScrewedUpMode();
    }

    public boolean isHandTranslucent(InteractionHand hand) {
        ItemStack heldItem = hand.getItemInHand((EntityPlayer)Minecraft.getMinecraft().thePlayer);
        if (heldItem == null) {
            return false;
        }
        Item item = heldItem.getItem();
        if (item instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item;
            Map<Block, RenderLayer> blockTypeIds = BlockRenderingSettings.INSTANCE.getBlockTypeIds();
            return blockTypeIds != null && blockTypeIds.get(itemBlock.field_150939_a) == RenderLayer.translucent();
        }
        return false;
    }

    public boolean isAnyHandTranslucent() {
        return this.isHandTranslucent(InteractionHand.MAIN_HAND) || this.isHandTranslucent(InteractionHand.OFF_HAND);
    }

    public void renderSolid(float tickDelta, Camera camera, RenderGlobal gameRenderer, WorldRenderingPipeline pipeline) {
        if (!this.canRender(camera, gameRenderer) || !IrisApi.getInstance().isShaderPackInUse()) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_SOLID);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        mc.mcProfiler.startSection("iris_hand");
        this.setupGlState(gameRenderer, camera, tickDelta);
        this.renderingSolid = true;
        mc.entityRenderer.enableLightmap((double)tickDelta);
        mc.entityRenderer.itemRenderer.renderItemInFirstPerson(tickDelta);
        mc.entityRenderer.disableLightmap((double)tickDelta);
        GLStateManager.defaultBlendFunc();
        GL11.glDepthMask((boolean)false);
        GL11.glPopMatrix();
        mc.mcProfiler.endSection();
        this.resetProjectionMatrix();
        this.renderingSolid = false;
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    public void renderTranslucent(float tickDelta, Camera camera, RenderGlobal gameRenderer, WorldRenderingPipeline pipeline) {
        if (!(this.canRender(camera, gameRenderer) && this.isAnyHandTranslucent() && IrisApi.getInstance().isShaderPackInUse())) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        this.ACTIVE = true;
        pipeline.setPhase(WorldRenderingPhase.HAND_TRANSLUCENT);
        GL11.glPushMatrix();
        mc.mcProfiler.startSection("iris_hand_translucent");
        this.setupGlState(gameRenderer, camera, tickDelta);
        mc.entityRenderer.enableLightmap((double)tickDelta);
        mc.entityRenderer.itemRenderer.renderItemInFirstPerson(tickDelta);
        mc.entityRenderer.disableLightmap((double)tickDelta);
        GL11.glPopMatrix();
        this.resetProjectionMatrix();
        Minecraft.getMinecraft().mcProfiler.endSection();
        pipeline.setPhase(WorldRenderingPhase.NONE);
        this.ACTIVE = false;
    }

    private void resetProjectionMatrix() {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMultMatrix((FloatBuffer)RenderingState.INSTANCE.getProjectionBuffer());
        GL11.glMatrixMode((int)5888);
    }

    public boolean isActive() {
        return this.ACTIVE;
    }

    public boolean isRenderingSolid() {
        return this.renderingSolid;
    }
}

