/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.gtnewhorizons.angelica.rendering.RenderingState;
import java.util.Objects;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public final class CelestialUniforms {
    private final float sunPathRotation;

    public CelestialUniforms(float sunPathRotation) {
        this.sunPathRotation = sunPathRotation;
    }

    public void addCelestialUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", CelestialUniforms::getSunAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    public static float getSunAngle() {
        float skyAngle = CelestialUniforms.getSkyAngle();
        if (skyAngle < 0.75f) {
            return skyAngle + 0.25f;
        }
        return skyAngle - 0.75f;
    }

    private static float getShadowAngle() {
        float shadowAngle = CelestialUniforms.getSunAngle();
        if (!CelestialUniforms.isDay()) {
            shadowAngle -= 0.5f;
        }
        return shadowAngle;
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(-100.0f);
    }

    public Vector4f getShadowLightPosition() {
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(100.0f) : this.getCelestialPositionInWorldSpace(-100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(float y) {
        Vector4f position = new Vector4f(0.0f, y, 0.0f, 0.0f);
        Matrix4f celestial = new Matrix4f().identity();
        celestial.rotateY(-1.5707964f);
        celestial.rotateZ(this.sunPathRotation * ((float)Math.PI / 180));
        celestial.rotateX(CelestialUniforms.getSkyAngle() * 360.0f * ((float)Math.PI / 180));
        celestial.transform(position);
        return position;
    }

    private Vector4f getCelestialPosition(float y) {
        Vector4f position = new Vector4f(0.0f, y, 0.0f, 0.0f);
        Matrix4f celestial = new Matrix4f((Matrix4fc)RenderingState.INSTANCE.getModelViewMatrix());
        celestial.rotateY(-1.5707964f);
        celestial.rotateZ(this.sunPathRotation * ((float)Math.PI / 180));
        celestial.rotateX(CelestialUniforms.getSkyAngle() * 360.0f * ((float)Math.PI / 180));
        position = celestial.transform(position);
        return position;
    }

    private static Vector4f getUpPosition() {
        Vector4f upVector = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f preCelestial = new Matrix4f((Matrix4fc)RenderingState.INSTANCE.getModelViewMatrix());
        preCelestial.rotateY(-1.5707964f);
        upVector = preCelestial.transform(upVector);
        return upVector;
    }

    public static boolean isDay() {
        return (double)CelestialUniforms.getSunAngle() <= 0.5;
    }

    private static WorldClient getWorld() {
        return Objects.requireNonNull(Minecraft.getMinecraft().theWorld);
    }

    private static float getSkyAngle() {
        return CelestialUniforms.getWorld().getCelestialAngle(CapturedRenderingState.INSTANCE.getTickDelta());
    }
}

