/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.blending;

import java.util.Optional;

public enum AlphaTestFunction {
    NEVER(512),
    LESS(513),
    EQUAL(514),
    LEQUAL(515),
    GREATER(516),
    NOTEQUAL(517),
    GEQUAL(518),
    ALWAYS(519);

    private final int glId;

    private AlphaTestFunction(int glFormat) {
        this.glId = glFormat;
    }

    public static Optional<AlphaTestFunction> fromGlId(int glId) {
        Optional<AlphaTestFunction> optional;
        switch (glId) {
            case 512: {
                optional = Optional.of(NEVER);
                break;
            }
            case 513: {
                optional = Optional.of(LESS);
                break;
            }
            case 514: {
                optional = Optional.of(EQUAL);
                break;
            }
            case 515: {
                optional = Optional.of(LEQUAL);
                break;
            }
            case 516: {
                optional = Optional.of(GREATER);
                break;
            }
            case 517: {
                optional = Optional.of(NOTEQUAL);
                break;
            }
            case 518: {
                optional = Optional.of(GEQUAL);
                break;
            }
            case 519: {
                optional = Optional.of(ALWAYS);
                break;
            }
            default: {
                optional = Optional.empty();
            }
        }
        return optional;
    }

    public static Optional<AlphaTestFunction> fromString(String name) {
        if ("GL_ALWAYS".equals(name)) {
            return Optional.of(ALWAYS);
        }
        try {
            return Optional.of(AlphaTestFunction.valueOf(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public int getGlId() {
        return this.glId;
    }
}

