/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.gui;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizons.angelica.client.font.FontStrategist;
import com.gtnewhorizons.angelica.client.gui.SliderClone;
import com.gtnewhorizons.angelica.config.FontConfig;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.coderbot.iris.gui.element.widget.IrisButton;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;

public class FontConfigScreen
extends GuiScreen {
    private static final Font[] availableFonts = FontStrategist.getAvailableFonts();
    private final GuiScreen parent;
    private final String title;
    private final String searchPrompt;
    private String currentPrimaryFontName;
    private String currentFallbackFontName;
    private FontList fontList;
    private int selectedPrimaryFontListPos = -1;
    private int selectedFallbackFontListPos = -1;
    private ArrayList<Font> displayedFonts;
    private GuiTextField searchBox;
    SliderClone.Option optFontQuality = new SliderClone.Option(6.0f, 72.0f, 6.0f);
    SliderClone.Option optShadowOffset = new SliderClone.Option(0.0f, 2.0f, 0.05f);
    SliderClone.Option optGlyphAspect = new SliderClone.Option(-1.0f, 1.0f, 0.05f);
    SliderClone.Option optGlyphScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    SliderClone.Option optWhitespaceScale = new SliderClone.Option(0.1f, 3.0f, 0.05f);
    SliderClone.Option optGlyphSpacing = new SliderClone.Option(-2.0f, 2.0f, 0.05f);
    SliderClone.Option optFontAAMode = new SliderClone.Option(0.0f, 2.0f, 1.0f);
    SliderClone.Option optFontAAStrength = new SliderClone.Option(1.0f, 24.0f, 1.0f);
    private int qualityLast = FontConfig.customFontQuality;
    private float lastMouseX = 0.0f;
    private float lastMouseY = 0.0f;
    private long lastStillTime = 0L;

    public FontConfigScreen(GuiScreen parent) {
        this.title = I18n.format((String)"options.angelica.fontconfig.title", (Object[])new Object[0]);
        this.searchPrompt = I18n.format((String)"options.angelica.fontconfig.searchprompt", (Object[])new Object[0]);
        this.parent = parent;
        this.currentPrimaryFontName = FontConfig.customFontNamePrimary;
        this.currentFallbackFontName = FontConfig.customFontNameFallback;
        this.displayedFonts = new ArrayList<Font>(Arrays.asList(availableFonts));
        for (int i = 0; i < availableFonts.length; ++i) {
            if (Objects.equals(this.currentPrimaryFontName, availableFonts[i].getFontName())) {
                this.selectedPrimaryFontListPos = i;
            }
            if (!Objects.equals(this.currentFallbackFontName, availableFonts[i].getFontName())) continue;
            this.selectedFallbackFontListPos = i;
        }
    }

    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchBox = new GuiTextField(this.fontRendererObj, this.width / 2 - 120, 24, 240, 20);
        this.searchBox.setMaxStringLength(64);
        this.fontList = new FontList();
        this.initButtons();
    }

    private void initButtons() {
        this.buttonList.add(new IrisButton(this.width / 2 - 81 - 165, this.height - 20 - 7, 162, 20, FontConfig.enableCustomFont ? I18n.format((String)"options.angelica.fontconfig.disable_custom_font", (Object[])new Object[0]) : I18n.format((String)"options.angelica.fontconfig.enable_custom_font", (Object[])new Object[0]), this::toggleCustomFont));
        this.buttonList.add(new IrisButton(this.width / 2 - 80, this.height - 20 - 7, 160, 20, I18n.format((String)"options.angelica.fontconfig.reset_values", (Object[])new Object[0]), this::resetValues));
        this.buttonList.add(new IrisButton(this.width / 2 - 81 + 165, this.height - 20 - 7, 162, 20, I18n.format((String)"gui.done", (Object[])new Object[0]), button -> this.onClose()));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 - 186, this.height - 40 - 11, 120, 20, this.optFontQuality, FontConfig.customFontQuality, this::setFontQuality, value -> I18n.format((String)"options.angelica.fontconfig.font_quality", (Object[])new Object[]{String.format("%2.0f", value)}), "options.angelica.fontconfig.font_quality.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 - 186, this.height - 60 - 15, 120, 20, this.optShadowOffset, FontConfig.fontShadowOffset, value -> {
            FontConfig.fontShadowOffset = value.floatValue();
        }, value -> I18n.format((String)"options.angelica.fontconfig.shadow_offset", (Object[])new Object[]{String.format("x%3.2f", value)}), "options.angelica.fontconfig.shadow_offset.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 - 62, this.height - 40 - 11, 120, 20, this.optGlyphAspect, FontConfig.glyphAspect, value -> {
            FontConfig.glyphAspect = value.floatValue();
        }, value -> I18n.format((String)"options.angelica.fontconfig.glyph_aspect", (Object[])new Object[]{String.format("%3.2f", value)}), "options.angelica.fontconfig.glyph_aspect.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 - 62, this.height - 60 - 15, 120, 20, this.optGlyphScale, FontConfig.glyphScale, value -> {
            FontConfig.glyphScale = value.floatValue();
        }, value -> I18n.format((String)"options.angelica.fontconfig.glyph_scale", (Object[])new Object[]{String.format("x%3.2f", value)}), "options.angelica.fontconfig.glyph_scale.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 + 62, this.height - 40 - 11, 120, 20, this.optWhitespaceScale, FontConfig.whitespaceScale, value -> {
            FontConfig.whitespaceScale = value.floatValue();
        }, value -> I18n.format((String)"options.angelica.fontconfig.whitespace_scale", (Object[])new Object[]{String.format("x%3.2f", value)}), "options.angelica.fontconfig.whitespace_scale.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 + 62, this.height - 60 - 15, 120, 20, this.optGlyphSpacing, FontConfig.glyphSpacing, value -> {
            FontConfig.glyphSpacing = value.floatValue();
        }, value -> I18n.format((String)"options.angelica.fontconfig.glyph_spacing", (Object[])new Object[]{String.format("%3.2f", value)}), "options.angelica.fontconfig.glyph_spacing.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 + 186, this.height - 40 - 11, 120, 20, this.optFontAAStrength, FontConfig.fontAAStrength, value -> {
            FontConfig.fontAAStrength = value.intValue();
        }, value -> I18n.format((String)"options.angelica.fontconfig.font_aa_strength", (Object[])new Object[]{String.format("%.0f", value)}), "options.angelica.fontconfig.font_aa_strength.tooltip"));
        this.buttonList.add(new SliderClone(this.width / 2 - 60 + 186, this.height - 60 - 15, 120, 20, this.optFontAAMode, FontConfig.fontAAMode, value -> {
            FontConfig.fontAAMode = value.intValue();
        }, this::fontAAModeFormat, "options.angelica.fontconfig.aamode.tooltip"));
    }

    private void onClose() {
        this.applyChanges(true);
        this.mc.displayGuiScreen(this.parent);
    }

    private void applyChanges(boolean finalApply) {
        int pos = this.selectedPrimaryFontListPos;
        if (pos >= 0 && pos < this.displayedFonts.size()) {
            FontConfig.customFontNamePrimary = this.displayedFonts.get(pos).getFontName();
        }
        if ((pos = this.selectedFallbackFontListPos) >= 0 && pos < this.displayedFonts.size()) {
            FontConfig.customFontNameFallback = this.displayedFonts.get(pos).getFontName();
        }
        FontStrategist.reloadCustomFontProviders();
        if (finalApply) {
            ConfigurationManager.save((Class[])new Class[]{FontConfig.class});
        }
    }

    private void resetValues(IrisButton button) {
        try {
            ConfigurationManager.getConfigElements(FontConfig.class).forEach(elem -> elem.set(elem.getDefault()));
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        this.selectedPrimaryFontListPos = -1;
        this.selectedFallbackFontListPos = -1;
        FontStrategist.customFontInUse = false;
        this.buttonList.clear();
        this.initButtons();
    }

    private void toggleCustomFont(IrisButton button) {
        FontConfig.enableCustomFont = !FontConfig.enableCustomFont;
        this.applyChanges(false);
        button.displayString = FontConfig.enableCustomFont ? I18n.format((String)"options.angelica.fontconfig.disable_custom_font", (Object[])new Object[0]) : I18n.format((String)"options.angelica.fontconfig.enable_custom_font", (Object[])new Object[0]);
    }

    private void setFontQuality(float quality) {
        FontConfig.customFontQuality = (int)quality;
        if (this.qualityLast != (int)quality) {
            this.applyChanges(false);
        }
        this.qualityLast = (int)quality;
    }

    private String fontAAModeFormat(float AAmode) {
        String string;
        switch ((int)AAmode) {
            case 2: {
                string = I18n.format((String)"options.angelica.fontconfig.aamode.aa_16x", (Object[])new Object[0]);
                break;
            }
            case 1: {
                string = I18n.format((String)"options.angelica.fontconfig.aamode.aa_4x", (Object[])new Object[0]);
                break;
            }
            default: {
                string = I18n.format((String)"options.angelica.fontconfig.aamode.aa_none", (Object[])new Object[0]);
            }
        }
        return string;
    }

    public void drawScreen(int mouseX, int mouseY, float delta) {
        super.drawDefaultBackground();
        this.fontList.drawScreen(mouseX, mouseY, delta);
        this.searchBox.drawTextBox();
        if (!this.searchBox.isFocused() && this.searchBox.getText().isEmpty()) {
            this.drawCenteredString(this.fontRendererObj, this.searchPrompt, this.searchBox.xPosition + this.fontRendererObj.getStringWidth(this.searchPrompt) / 2 + 4, this.searchBox.yPosition + this.searchBox.height / 2 - 4, 0xFFFFFF);
        }
        this.drawCenteredString(this.fontRendererObj, this.title, (int)((double)this.width * 0.5), 8, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, I18n.format((String)"options.angelica.fontconfig.currentfonts", (Object[])new Object[]{FontConfig.customFontNamePrimary, FontConfig.customFontNameFallback}), (int)((double)this.width * 0.5), this.height - 92, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, delta);
        for (GuiButton guiButton : this.buttonList) {
            if (!(guiButton instanceof SliderClone)) continue;
            SliderClone slider = (SliderClone)guiButton;
            int top = slider.yPosition;
            int bot = slider.yPosition + slider.height;
            int left = slider.xPosition;
            int right = slider.xPosition + slider.width;
            if (mouseY < top || mouseY >= bot || mouseX < left || mouseX >= right) continue;
            if ((float)mouseX == this.lastMouseX && (float)mouseY == this.lastMouseY) {
                if (this.lastStillTime == 0L) {
                    this.lastStillTime = System.currentTimeMillis();
                }
                if (this.lastStillTime + 500L >= System.currentTimeMillis()) break;
                this.displayTooltip(mouseX, mouseY, slider.tooltipKey);
                break;
            }
            this.lastStillTime = 0L;
            break;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void displayTooltip(int x, int y, String langKey) {
        List lines = this.fontRendererObj.listFormattedStringToWidth(I18n.format((String)langKey, (Object[])new Object[0]), this.width / 2);
        this.drawHoveringText(lines, x, y, this.fontRendererObj);
    }

    protected void actionPerformed(GuiButton guiButton) {
        if (guiButton.enabled && guiButton instanceof IrisButton) {
            IrisButton irisButton = (IrisButton)guiButton;
            irisButton.onPress();
        }
    }

    protected void keyTyped(char typedChar, int keyCode) {
        if (this.searchBox.isFocused()) {
            if (keyCode == 1) {
                this.searchBox.setFocused(false);
            }
            this.searchBox.textboxKeyTyped(typedChar, keyCode);
            this.displayedFonts = this.filterFonts(this.searchBox.getText().toLowerCase());
        }
        if (keyCode == 1) {
            this.onClose();
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.searchBox.mouseClicked(mouseX, mouseY, mouseButton);
        this.fontList.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void updateScreen() {
        this.searchBox.updateCursorCounter();
    }

    private ArrayList<Font> filterFonts(String search) {
        ArrayList results = search == null || search.isEmpty() ? new ArrayList(Arrays.asList(availableFonts)) : Arrays.stream(availableFonts).filter(font -> font.getFontName().toLowerCase().contains(search)).collect(Collectors.toCollection(ArrayList::new));
        this.selectedPrimaryFontListPos = -1;
        this.selectedFallbackFontListPos = -1;
        for (int i = 0; i < results.size(); ++i) {
            if (Objects.equals(this.currentPrimaryFontName, ((Font)results.get(i)).getFontName())) {
                this.selectedPrimaryFontListPos = i;
            }
            if (!Objects.equals(this.currentFallbackFontName, ((Font)results.get(i)).getFontName())) continue;
            this.selectedFallbackFontListPos = i;
        }
        return results;
    }

    class FontList
    extends GuiSlot {
        public FontList() {
            super(FontConfigScreen.this.mc, FontConfigScreen.this.width, FontConfigScreen.this.height, 52, FontConfigScreen.this.height - 100, 18);
        }

        private void mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (mouseY < this.top || mouseY > this.bottom) {
                return;
            }
            int listLeftBound = this.width / 2 - this.getListWidth() / 2;
            int listRightBound = this.width / 2 + this.getListWidth() / 2;
            if (mouseX < listLeftBound || mouseX > listRightBound) {
                return;
            }
            int mousePosInList = mouseY - this.top - this.headerPadding + (int)this.amountScrolled - 4;
            int slotIndex = mousePosInList / this.slotHeight;
            if (slotIndex < 0 || slotIndex >= this.getSize()) {
                return;
            }
            if (mouseButton == 0) {
                this.onElemClicked(slotIndex, false);
            } else if (mouseButton == 1) {
                this.onElemClicked(slotIndex, true);
            }
        }

        protected void onElemClicked(int index, boolean rightClick) {
            if (!rightClick) {
                FontConfigScreen.this.selectedPrimaryFontListPos = index;
                FontConfigScreen.this.currentPrimaryFontName = ((Font)FontConfigScreen.this.displayedFonts.get(index)).getFontName();
            } else {
                FontConfigScreen.this.selectedFallbackFontListPos = index;
                FontConfigScreen.this.currentFallbackFontName = ((Font)FontConfigScreen.this.displayedFonts.get(index)).getFontName();
            }
            FontConfigScreen.this.applyChanges(false);
        }

        protected boolean isSelected(int index) {
            return index == FontConfigScreen.this.selectedPrimaryFontListPos || index == FontConfigScreen.this.selectedFallbackFontListPos;
        }

        protected int getSize() {
            return FontConfigScreen.this.displayedFonts.size();
        }

        protected int getContentHeight() {
            return this.getSize() * 18;
        }

        protected int getScrollBarX() {
            return this.width * 11 / 12 - 5;
        }

        public int getListWidth() {
            return this.width * 2 / 3;
        }

        protected void elementClicked(int index, boolean doubleClicked, int mouseX, int mouseY) {
        }

        protected void drawBackground() {
            FontConfigScreen.this.drawDefaultBackground();
        }

        protected void drawSlot(int index, int x, int y, int p_148126_4_, Tessellator tessellator, int p_148126_6_, int p_148126_7_) {
            int color = 0xFFFFFF;
            if (index == FontConfigScreen.this.selectedPrimaryFontListPos) {
                color &= 0xFFFF55;
            }
            if (index == FontConfigScreen.this.selectedFallbackFontListPos) {
                color &= 0x55FFFF;
            }
            FontConfigScreen.this.drawCenteredString(FontConfigScreen.this.fontRendererObj, ((Font)FontConfigScreen.this.displayedFonts.get(index)).getFontName(), this.width / 2, y + 1, color);
        }
    }
}

