/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.sodium;

import com.gtnewhorizons.angelica.compat.mojang.Camera;
import com.gtnewhorizons.angelica.compat.toremove.MatrixStack;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.IRenderGlobalExt;
import com.gtnewhorizons.angelica.rendering.AngelicaRenderQueue;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import lombok.Generated;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import net.coderbot.iris.Iris;
import net.coderbot.iris.layer.GbufferPrograms;
import net.coderbot.iris.pipeline.HandRenderer;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.pipeline.WorldRenderingPhase;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import org.joml.Math;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderGlobal.class}, priority=2000)
public class MixinRenderGlobal
implements IRenderGlobalExt {
    @Shadow
    public int renderChunksWide;
    @Shadow
    public int renderChunksTall;
    @Shadow
    public int renderChunksDeep;
    @Shadow
    public WorldClient theWorld;
    @Shadow
    public Minecraft mc;
    @Shadow
    public int renderDistanceChunks;
    @Shadow
    public WorldRenderer[] worldRenderers;
    @Shadow
    public WorldRenderer[] sortedWorldRenderers;
    @Shadow
    @Final
    private TextureManager renderEngine;
    @Unique
    private SodiumWorldRenderer renderer;
    private int sodium$frame;

    @Override
    public void scheduleTerrainUpdate() {
        this.renderer.scheduleTerrainUpdate();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void sodium$initRenderer(Minecraft mc, CallbackInfo ci) {
        this.renderer = SodiumWorldRenderer.create(mc);
    }

    @Inject(method={"Lnet/minecraft/client/renderer/RenderGlobal;setWorldAndLoadRenderers(Lnet/minecraft/client/multiplayer/WorldClient;)V"}, at={@At(value="RETURN")})
    private void sodium$setWorldAndLoadRenderers(WorldClient world, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setWorld(world);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public String getDebugInfoRenders() {
        return this.renderer.getChunksDebugString();
    }

    @Overwrite
    public int renderSortedRenderers(int x, int z, int pass, double partialTicks) {
        return 0;
    }

    @Overwrite
    public void renderAllRenderLists(int pass, double partialTicks) {
    }

    @Overwrite
    private void checkOcclusionQueryResult(int x, int z) {
    }

    @Overwrite
    public void markRenderersForNewPosition(int p_72722_1_, int p_72722_2_, int p_72722_3_) {
    }

    @Overwrite
    public boolean updateRenderers(EntityLivingBase e, boolean b) {
        AngelicaRenderQueue.processTasks(1);
        return true;
    }

    @Unique
    private void iris$beginTranslucents(WorldRenderingPipeline pipeline, Camera camera) {
        pipeline.beginHand();
        HandRenderer.INSTANCE.renderSolid(camera.getPartialTicks(), camera, this.mc.renderGlobal, pipeline);
        this.mc.mcProfiler.endStartSection("iris_pre_translucent");
        pipeline.beginTranslucents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public int sortAndRender(EntityLivingBase entity, int pass, double partialTicks) {
        WorldRenderingPipeline pipeline;
        if (!AngelicaConfig.enableIris) {
            pipeline = null;
        } else {
            pipeline = Iris.getPipelineManager().getPipelineNullable();
            if (pass == 0) {
                pipeline.setPhase(WorldRenderingPhase.TERRAIN_CUTOUT);
            } else if (pass == 1) {
                Camera camera = new Camera(this.mc.renderViewEntity, (float)partialTicks);
                if (!ShadowRenderer.ACTIVE) {
                    this.iris$beginTranslucents(pipeline, camera);
                }
                pipeline.setPhase(WorldRenderingPhase.TERRAIN_TRANSLUCENT);
                this.renderEngine.bindTexture(TextureMap.locationBlocksTexture);
            }
        }
        if (this.renderDistanceChunks != this.mc.gameSettings.renderDistanceChunks) {
            this.loadRenderers();
        }
        RenderHelper.disableStandardItemLighting();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        this.mc.entityRenderer.enableLightmap(partialTicks);
        RenderDevice.enterManagedCode();
        double x = Math.lerp((double)entity.lastTickPosX, (double)entity.posX, (double)partialTicks);
        double y = Math.lerp((double)entity.lastTickPosY, (double)entity.posY, (double)partialTicks);
        double z = Math.lerp((double)entity.lastTickPosZ, (double)entity.posZ, (double)partialTicks);
        try {
            MatrixStack matrixStack = new MatrixStack(ShadowRenderer.ACTIVE ? ShadowRenderer.MODELVIEW : RenderingState.INSTANCE.getModelViewMatrix());
            this.mc.mcProfiler.endStartSection("draw_chunk_layer_" + pass);
            this.renderer.drawChunkLayer(BlockRenderPass.VALUES[pass], matrixStack, x, y, z);
        }
        finally {
            RenderDevice.exitManagedCode();
            this.mc.entityRenderer.disableLightmap(partialTicks);
        }
        if (pipeline != null) {
            pipeline.setPhase(WorldRenderingPhase.NONE);
        }
        return 0;
    }

    private boolean isSpectatorMode() {
        PlayerControllerMP controller = Minecraft.getMinecraft().playerController;
        if (controller == null) {
            return false;
        }
        return controller.currentGameType.getID() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void clipRenderersByFrustum(ICamera frustrum, float partialTicks) {
        RenderDevice.enterManagedCode();
        Frustrum frustum = (Frustrum)frustrum;
        boolean hasForcedFrustum = false;
        boolean spectator = this.isSpectatorMode();
        Camera camera = new Camera(this.mc.renderViewEntity, partialTicks);
        frustum.setPosition(camera.getPos().x, camera.getPos().y, camera.getPos().z);
        try {
            this.renderer.updateChunks(camera, frustum, hasForcedFrustum, this.sodium$frame++, spectator);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void markBlocksForUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Overwrite
    public void markBlockForUpdate(int x, int y, int z) {
        this.renderer.scheduleRebuildForBlockArea(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, false);
    }

    @Overwrite
    public void markBlockForRenderUpdate(int x, int y, int z) {
        this.renderer.scheduleRebuildForBlockArea(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, false);
    }

    @Overwrite
    public void markBlockRangeForRenderUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Inject(method={"loadRenderers"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        this.reload();
    }

    @Override
    public void reload() {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void loadRenderers() {
        if (this.theWorld == null) {
            return;
        }
        Blocks.leaves.setGraphicsLevel(this.mc.gameSettings.fancyGraphics);
        Blocks.leaves2.setGraphicsLevel(this.mc.gameSettings.fancyGraphics);
        this.renderDistanceChunks = this.mc.gameSettings.renderDistanceChunks;
        this.worldRenderers = null;
        this.sortedWorldRenderers = null;
        this.renderChunksWide = 0;
        this.renderChunksTall = 0;
        this.renderChunksDeep = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"renderEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/RenderManager;renderEntitySimple(Lnet/minecraft/entity/Entity;F)Z")})
    private boolean angelica$renderEntitySimple(RenderManager instance, Entity entity, float partialTicks, Operation<Boolean> original) {
        CapturedRenderingState.INSTANCE.setCurrentEntity(entity.getEntityId());
        GbufferPrograms.beginEntities();
        try {
            boolean bl = (Boolean)original.call(new Object[]{instance, entity, Float.valueOf(partialTicks)});
            return bl;
        }
        finally {
            CapturedRenderingState.INSTANCE.setCurrentEntity(-1);
            GbufferPrograms.endEntities();
        }
    }

    @Inject(method={"renderEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderHelper;enableStandardItemLighting()V", shift=At.Shift.AFTER)})
    public void sodium$renderTileEntities(EntityLivingBase entity, ICamera camera, float partialTicks, CallbackInfo ci) {
        this.renderer.renderTileEntities(entity, camera, partialTicks);
    }

    @Redirect(method={"renderEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isInRangeToRender3d(DDD)Z"))
    private boolean isInRange(Entity e, double x, double y, double z) {
        return e.isInRangeToRender3d(x, y, z) && SodiumWorldRenderer.getInstance().isEntityVisible(e);
    }

    @Generated
    public SodiumWorldRenderer getRenderer() {
        return this.renderer;
    }
}

