/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mal.resource;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import java.util.Comparator;
import java.util.regex.Pattern;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;

public class ResourceLocationWithSource
extends ResourceLocation {
    private final IResourcePack source;
    private final int order;
    private final boolean isDirectory;

    public ResourceLocationWithSource(IResourcePack source, ResourceLocation resource) {
        super(resource.getResourceDomain(), resource.getResourcePath().replaceFirst("/$", ""));
        this.source = source;
        this.order = ResourceList.getResourcePackOrder(source);
        this.isDirectory = resource.getResourcePath().endsWith("/");
    }

    public IResourcePack getSource() {
        return this.source;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    static class Comparator1
    implements Comparator<ResourceLocationWithSource> {
        private final boolean bySource;
        private final String suffixExpr;

        Comparator1() {
            this(false, null);
        }

        Comparator1(boolean bySource, String suffix) {
            this.bySource = bySource;
            this.suffixExpr = MCPatcherUtils.isNullOrEmpty(suffix) ? null : Pattern.quote(suffix) + "$";
        }

        @Override
        public int compare(ResourceLocationWithSource o1, ResourceLocationWithSource o2) {
            String f2;
            String f1;
            String n2;
            int result;
            if (this.bySource && (result = o1.getOrder() - o2.getOrder()) != 0) {
                return result;
            }
            String n1 = o1.getResourceDomain();
            result = n1.compareTo(n2 = o2.getResourceDomain());
            if (result != 0) {
                return result;
            }
            String p1 = o1.getResourcePath();
            String p2 = o2.getResourcePath();
            if (this.suffixExpr != null && (result = (f1 = p1.replaceAll(".*/", "").replaceFirst(this.suffixExpr, "")).compareTo(f2 = p2.replaceAll(".*/", "").replaceFirst(this.suffixExpr, ""))) != 0) {
                return result;
            }
            return p1.compareTo(p2);
        }
    }
}

