/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.occlusion;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOcclusionCache {
    private static final byte UNCACHED_VALUE = 127;
    private final Object2ByteLinkedOpenHashMap<CachedOcclusionShapeTest> map;
    private final BlockPos cpos = new BlockPos();

    public BlockOcclusionCache() {
        this.map = new Object2ByteLinkedOpenHashMap(2048, 0.5f);
        this.map.defaultReturnValue((byte)127);
    }

    public boolean shouldDrawSide(Block block, int meta, IBlockAccess view, BlockPos pos, ForgeDirection facing) {
        if (facing == ForgeDirection.UNKNOWN) {
            return true;
        }
        BlockPos adjPos = this.cpos;
        adjPos.set(pos.getX() + facing.offsetX, pos.getY() + facing.offsetY, pos.getZ() + facing.offsetZ);
        Block adjState = view.getBlock(adjPos.x, adjPos.y, adjPos.z);
        return !adjState.isOpaqueCube();
    }

    private static final class CachedOcclusionShapeTest {
        private Block a;
        private Block b;
        private int hashCode;

        private CachedOcclusionShapeTest() {
        }

        private CachedOcclusionShapeTest(Block a, Block b, int hashCode) {
            this.a = a;
            this.b = b;
            this.hashCode = hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof CachedOcclusionShapeTest) {
                CachedOcclusionShapeTest that = (CachedOcclusionShapeTest)o;
                return this.a == that.a && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

