/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui;

import java.util.ArrayDeque;
import java.util.Deque;
import lombok.Generated;
import net.coderbot.iris.gui.element.ShaderPackOptionList;

public class NavigationController {
    private ShaderPackOptionList optionList;
    private String currentScreen = null;
    private final Deque<String> history = new ArrayDeque<String>();

    public void back() {
        if (this.history.size() > 0) {
            this.history.removeLast();
            this.currentScreen = this.history.size() > 0 ? this.history.getLast() : null;
        } else {
            this.currentScreen = null;
        }
        this.rebuild();
    }

    public void open(String screen) {
        this.currentScreen = screen;
        this.history.addLast(screen);
        this.rebuild();
    }

    public void rebuild() {
        if (this.optionList != null) {
            this.optionList.rebuild();
        }
    }

    public void refresh() {
        if (this.optionList != null) {
            this.optionList.refresh();
        }
    }

    public boolean hasHistory() {
        return this.history.size() > 0;
    }

    public void setActiveOptionList(ShaderPackOptionList optionList) {
        this.optionList = optionList;
    }

    @Generated
    public String getCurrentScreen() {
        return this.currentScreen;
    }
}

