/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.debug;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryStack;
import com.gtnewhorizon.gtnhlib.client.renderer.shader.ShaderProgram;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public abstract class F3Graph {
    private static final int NUM_SAMPLES = 240;
    private static final int VERT_FLOATS = 2;
    private static final int VERT_COUNT = 4;
    private static final int BORDER = 1;
    private static final int HEIGHT = 60;
    private static final int WIDTH = 240;
    private static final int FONT_COLOR = -2039584;
    private final FloatBuffer sampleBuf = BufferUtils.createFloatBuffer((int)240);
    private final long[] samples = new long[240];
    private int samplesHead = 0;
    private boolean initialized = false;
    private ShaderProgram shader;
    private int aPos;
    private int uFBWidth;
    private int uFBHeight;
    private int uScaleFactor;
    private int uHeadIdx;
    private int uSamples;
    private int vertBuf;
    private final ResourceLocation texture;
    private final float pxPerNs;
    private final boolean left;
    private long sum;

    protected F3Graph(ResourceLocation texture, float pxPerNs, boolean left) {
        this.texture = texture;
        this.pxPerNs = pxPerNs;
        this.left = left;
    }

    public void putSample(long time) {
        this.sum -= this.samples[this.samplesHead];
        this.sum += time;
        this.samples[this.samplesHead] = time;
        this.sampleBuf.put(this.samplesHead, time);
        this.samplesHead = (this.samplesHead + 1) % 240;
    }

    private int getVertX(ScaledResolution sres, int idx) {
        int n;
        if (this.left) {
            int n2;
            switch (idx) {
                case 0: 
                case 3: {
                    n2 = 242;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Tried to get out-of-bounds vertex for graph!");
                }
            }
            return n2;
        }
        int displayWidth = sres.getScaledWidth();
        switch (idx) {
            case 0: 
            case 3: {
                n = displayWidth;
                break;
            }
            case 1: 
            case 2: {
                n = displayWidth - 240 - 2;
                break;
            }
            default: {
                throw new RuntimeException("Tried to get out-of-bounds vertex for graph!");
            }
        }
        return n;
    }

    private int getVertY(ScaledResolution sres, int idx) {
        int n;
        int displayHeight = sres.getScaledHeight();
        switch (idx) {
            case 0: 
            case 1: {
                n = displayHeight - 60 - 2;
                break;
            }
            case 2: 
            case 3: {
                n = displayHeight;
                break;
            }
            default: {
                throw new RuntimeException("Tried to get out-of-bounds vertex for graph!");
            }
        }
        return n;
    }

    private void init() {
        this.shader = new ShaderProgram("angelica", "shaders/debug_graph.vert.glsl", "shaders/debug_graph.frag.glsl");
        this.shader.use();
        this.aPos = this.shader.getAttribLocation("pos");
        this.uFBWidth = this.shader.getUniformLocation("fbWidth");
        this.uFBHeight = this.shader.getUniformLocation("fbHeight");
        this.uScaleFactor = this.shader.getUniformLocation("scaleFactor");
        this.uSamples = this.shader.getUniformLocation("samples");
        this.uHeadIdx = this.shader.getUniformLocation("headIdx");
        int uPxPerNs = this.shader.getUniformLocation("pxPerNs");
        int uLeft = this.shader.getUniformLocation("left");
        this.vertBuf = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vertBuf);
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer vertices = stack.mallocFloat(8);
            vertices.put(new float[]{1.0f, 1.0f, 241.0f, 1.0f, 1.0f, Float.MAX_VALUE, 241.0f, Float.MAX_VALUE});
            vertices.rewind();
            GL15.glBufferData((int)34962, (FloatBuffer)vertices, (int)35044);
        }
        GL15.glBindBuffer((int)34962, (int)0);
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution sr = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
        GL20.glUniform1f((int)this.uFBWidth, (float)mc.displayWidth);
        GL20.glUniform1f((int)this.uFBHeight, (float)mc.displayHeight);
        GL20.glUniform1f((int)this.uScaleFactor, (float)sr.getScaleFactor());
        GL20.glUniform1i((int)this.uHeadIdx, (int)this.samplesHead);
        GL20.glUniform1((int)this.uSamples, (FloatBuffer)this.sampleBuf);
        GL20.glUniform1f((int)uPxPerNs, (float)this.pxPerNs);
        GL20.glUniform1i((int)uLeft, (int)(this.left ? 1 : 0));
        ShaderProgram.clear();
    }

    public void render() {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution sr = new ScaledResolution(mc, mc.displayWidth, mc.displayHeight);
        Tessellator tess = Tessellator.instance;
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.3137255f, (float)0.3137255f, (float)0.3137255f, (float)0.5647059f);
        tess.startDrawingQuads();
        for (int i = 0; i < 4; ++i) {
            tess.addVertex((double)this.getVertX(sr, i), (double)this.getVertY(sr, i), 0.0);
        }
        tess.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        this.shader.use();
        GL20.glUniform1f((int)this.uFBWidth, (float)mc.displayWidth);
        GL20.glUniform1f((int)this.uFBHeight, (float)mc.displayHeight);
        GL20.glUniform1f((int)this.uScaleFactor, (float)sr.getScaleFactor());
        GL20.glUniform1i((int)this.uHeadIdx, (int)this.samplesHead);
        GL20.glUniform1((int)this.uSamples, (FloatBuffer)this.sampleBuf);
        GL15.glBindBuffer((int)34962, (int)this.vertBuf);
        GL20.glEnableVertexAttribArray((int)this.aPos);
        GL20.glVertexAttribPointer((int)this.aPos, (int)2, (int)5126, (boolean)false, (int)8, (long)0L);
        GL11.glEnableClientState((int)32884);
        if (!this.left) {
            GL11.glDisable((int)2884);
        }
        GL11.glDrawArrays((int)5, (int)0, (int)4);
        if (!this.left) {
            GL11.glEnable((int)2884);
        }
        GL11.glDisableClientState((int)32884);
        GL20.glDisableVertexAttribArray((int)this.aPos);
        GL15.glBindBuffer((int)34962, (int)0);
        ShaderProgram.clear();
        mc.getTextureManager().bindTexture(this.texture);
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)this.getVertX(sr, 0), (double)this.getVertY(sr, 0), 0.0, 1.0, 0.0);
        tess.addVertexWithUV((double)this.getVertX(sr, 1), (double)this.getVertY(sr, 1), 0.0, 0.0, 0.0);
        tess.addVertexWithUV((double)this.getVertX(sr, 2), (double)this.getVertY(sr, 2), 0.0, 0.0, 1.0);
        tess.addVertexWithUV((double)this.getVertX(sr, 3), (double)this.getVertY(sr, 3), 0.0, 1.0, 1.0);
        tess.draw();
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)3042);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < 240; ++i) {
            min = Math.min(min, this.samples[i]);
            max = Math.max(max, this.samples[i]);
        }
        String minStr = String.format("%.1f ms min", (double)min / 1000000.0);
        String avgStr = String.format("%.1f ms avg", (double)(this.sum / 1000000L) / 240.0);
        String maxStr = String.format("%.1f ms max", (double)max / 1000000.0);
        FontRenderer fr = mc.fontRenderer;
        int top = sr.getScaledHeight() - 60 - 2 - fr.FONT_HEIGHT;
        int scaledWidth = sr.getScaledWidth();
        if (this.left) {
            fr.drawString(minStr, 2, top, -2039584, true);
            fr.drawString(avgStr, 121 - fr.getStringWidth(avgStr) / 2, top, -2039584, true);
            fr.drawString(maxStr, 242 - fr.getStringWidth(maxStr), top, -2039584, true);
        } else {
            fr.drawString(minStr, scaledWidth - 242, top, -2039584, true);
            fr.drawString(avgStr, scaledWidth - (121 + fr.getStringWidth(avgStr) / 2), top, -2039584, true);
            fr.drawString(maxStr, scaledWidth - (2 + fr.getStringWidth(maxStr)), top, -2039584, true);
        }
    }
}

