/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.states;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.states.ISettableState;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.lwjgl.opengl.GL11;

public class LightModelState
implements ISettableState<LightModelState> {
    private static final Vector4f vector4f = new Vector4f();
    private static final Vector4i vector4i = new Vector4i();
    public final Vector4f ambient = new Vector4f(0.2f, 0.2f, 0.2f, 1.0f);
    public int colorControl = 33273;
    public float localViewer = 0.0f;
    public float twoSide = 0.0f;

    public void setAmbient(FloatBuffer newBuffer) {
        vector4f.set(newBuffer);
        if (GLStateManager.shouldBypassCache() || !this.ambient.equals((Object)vector4f)) {
            this.ambient.set((Vector4fc)vector4f);
            GL11.glLightModel((int)2899, (FloatBuffer)newBuffer);
        }
    }

    public void setAmbient(IntBuffer newBuffer) {
        vector4i.set(newBuffer);
        vector4f.set(GLStateManager.i2f(LightModelState.vector4i.x), GLStateManager.i2f(LightModelState.vector4i.y), GLStateManager.i2f(LightModelState.vector4i.z), GLStateManager.i2f(LightModelState.vector4i.w));
        if (GLStateManager.shouldBypassCache() || !this.ambient.equals((Object)vector4f)) {
            this.ambient.set((Vector4fc)vector4f);
            GL11.glLightModel((int)2899, (IntBuffer)newBuffer);
        }
    }

    public void setColorControl(int val) {
        if (GLStateManager.shouldBypassCache() || this.colorControl != val) {
            this.colorControl = val;
            GL11.glLightModeli((int)33272, (int)val);
        }
    }

    public void setColorControl(IntBuffer newBuffer) {
        this.setColorControl(newBuffer.get());
    }

    public void setLocalViewer(float val) {
        if (GLStateManager.shouldBypassCache() || Float.compare(this.localViewer, val) != 0) {
            this.localViewer = val;
            GL11.glLightModelf((int)2897, (float)val);
        }
    }

    public void setLocalViewer(FloatBuffer newBuffer) {
        this.setLocalViewer(newBuffer.get());
    }

    public void setLocalViewer(IntBuffer newBuffer) {
        this.setLocalViewer((float)newBuffer.get());
    }

    public void setLocalViewer(int val) {
        this.setLocalViewer((float)val);
    }

    public void setTwoSide(float val) {
        if (GLStateManager.shouldBypassCache() || Float.compare(this.twoSide, val) != 0) {
            this.twoSide = val;
            GL11.glLightModelf((int)2898, (float)val);
        }
    }

    public void setTwoSide(FloatBuffer newBuffer) {
        this.setTwoSide(newBuffer.get());
    }

    public void setTwoSide(IntBuffer newBuffer) {
        this.setTwoSide((float)newBuffer.get());
    }

    public void setTwoSide(int val) {
        this.setTwoSide((float)val);
    }

    @Override
    public LightModelState set(LightModelState state) {
        this.ambient.set((Vector4fc)state.ambient);
        this.colorControl = state.colorControl;
        this.localViewer = state.localViewer;
        this.twoSide = state.twoSide;
        return this;
    }

    @Override
    public boolean sameAs(Object state) {
        if (this == state) {
            return true;
        }
        if (!(state instanceof LightModelState)) {
            return false;
        }
        LightModelState lightModelState = (LightModelState)state;
        return this.ambient.equals((Object)lightModelState.ambient) && this.colorControl == lightModelState.colorControl && Float.compare(lightModelState.localViewer, this.localViewer) == 0 && Float.compare(lightModelState.twoSide, this.twoSide) == 0;
    }

    @Override
    public LightModelState copy() {
        return new LightModelState().set(this);
    }
}

