/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.angelica.animation;

import com.gtnewhorizons.angelica.AngelicaMod;
import com.gtnewhorizons.angelica.mixins.interfaces.IPatchedTextureAtlasSprite;
import com.gtnewhorizons.angelica.utils.AnimationMode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TextureMap.class}, priority=999)
public abstract class MixinTextureMap
extends AbstractTexture {
    @Shadow
    @Final
    private List<TextureAtlasSprite> listAnimatedSprites;
    @Unique
    private static final Minecraft mc = Minecraft.getMinecraft();

    @Overwrite
    public void updateAnimations() {
        boolean renderAllAnimations = AngelicaMod.animationsMode.is(AnimationMode.ALL);
        boolean renderVisibleAnimations = AngelicaMod.animationsMode.is(AnimationMode.VISIBLE_ONLY);
        MixinTextureMap.mc.mcProfiler.startSection("updateAnimations");
        GL11.glBindTexture((int)3553, (int)this.getGlTextureId());
        int size = this.listAnimatedSprites.size();
        for (int i = 0; i < size; ++i) {
            TextureAtlasSprite textureAtlasSprite = this.listAnimatedSprites.get(i);
            IPatchedTextureAtlasSprite patchedTextureAtlasSprite = (IPatchedTextureAtlasSprite)textureAtlasSprite;
            if (renderAllAnimations || renderVisibleAnimations && patchedTextureAtlasSprite.needsAnimationUpdate()) {
                MixinTextureMap.mc.mcProfiler.startSection(textureAtlasSprite.getIconName());
                textureAtlasSprite.updateAnimation();
                patchedTextureAtlasSprite.unmarkNeedsAnimationUpdate();
                MixinTextureMap.mc.mcProfiler.endSection();
                continue;
            }
            patchedTextureAtlasSprite.updateAnimationsDryRun();
        }
        MixinTextureMap.mc.mcProfiler.endSection();
    }
}

