/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.notfine.faceculling;

import jss.notfine.util.IFaceObstructionCheckHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockCactus.class})
public abstract class MixinBlockCactus
extends Block
implements IFaceObstructionCheckHelper {
    public boolean shouldSideBeRendered(IBlockAccess worldIn, int x, int y, int z, int side) {
        if (side > 1) {
            return true;
        }
        Block otherBlock = worldIn.getBlock(x, y, z);
        if (otherBlock.isOpaqueCube()) {
            return false;
        }
        if (otherBlock instanceof IFaceObstructionCheckHelper) {
            IFaceObstructionCheckHelper target = (IFaceObstructionCheckHelper)otherBlock;
            return target.isFaceNonObstructing(worldIn, x, y, z, side, 0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
        }
        return true;
    }

    @Override
    public boolean isFaceNonObstructing(IBlockAccess worldIn, int x, int y, int z, int side, double otherMinX, double otherMinY, double otherMinZ, double otherMaxX, double otherMaxY, double otherMaxZ) {
        if (this.getRenderBlockPass() == 1) {
            return true;
        }
        if (side > 1) {
            return true;
        }
        return otherMinX < 0.0625 || otherMinZ < 0.0625 || otherMaxX > 0.9375 || otherMaxZ > 0.9375;
    }

    MixinBlockCactus(Material material) {
        super(material);
    }
}

