/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.mixins.early.notfine.faceculling;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jss.notfine.util.IFaceObstructionCheckHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={BlockSnow.class})
public abstract class MixinBlockSnow
extends Block
implements IFaceObstructionCheckHelper {
    @Overwrite
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess worldIn, int x, int y, int z, int side) {
        if (side == 1 && this.maxY < 1.0) {
            return true;
        }
        Block otherBlock = worldIn.getBlock(x, y, z);
        if (otherBlock.isOpaqueCube()) {
            return false;
        }
        if (otherBlock instanceof IFaceObstructionCheckHelper) {
            IFaceObstructionCheckHelper target = (IFaceObstructionCheckHelper)otherBlock;
            return target.isFaceNonObstructing(worldIn, x, y, z, side, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return true;
    }

    @Override
    public boolean isFaceNonObstructing(IBlockAccess worldIn, int x, int y, int z, int side, double otherMinX, double otherMinY, double otherMinZ, double otherMaxX, double otherMaxY, double otherMaxZ) {
        boolean bl;
        if (this.getRenderBlockPass() == 1) {
            return true;
        }
        int meta = worldIn.getBlockMetadata(x, y, z) & 7;
        switch (side) {
            case 0: {
                if (meta != 7) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                bl = otherMaxY > (double)((float)(2 * (1 + meta)) * 0.0625f);
            }
        }
        return bl;
    }

    MixinBlockSnow(Material material) {
        super(material);
    }
}

