/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.rendering;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.ByteBuffer;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;

public class ItemRenderListManager {
    private static final Object2ObjectLinkedOpenHashMap<ItemProp, CachedVBO> vboCache = new Object2ObjectLinkedOpenHashMap(64);
    private static ByteBuffer quadBuffer = BufferUtils.createByteBuffer((int)(1026 * DefaultVertexFormat.POSITION_TEXTURE_NORMAL.getVertexSize() << 2));
    private static final int EXPIRY_TICKS = 1200;
    private static int smallestExpiry;
    private static final ItemProp prop;

    public static VertexBuffer pre(float minU, float minV, float maxU, float maxV, int widthSubdivisions, int heightSubdivisions, float thickness) {
        CachedVBO vbo;
        prop.set(minU, minV, maxU, maxV, widthSubdivisions, heightSubdivisions, thickness);
        if (!vboCache.isEmpty() && (vbo = (CachedVBO)vboCache.getAndMoveToLast((Object)prop)) != null) {
            int time = ItemRenderListManager.getElapsedTicks();
            vbo.render(time);
            if (time > smallestExpiry && time > (smallestExpiry = ((CachedVBO)vboCache.get(vboCache.firstKey())).expiry + 20)) {
                ((CachedVBO)ItemRenderListManager.vboCache.removeFirst()).delete();
                if (!vboCache.isEmpty()) {
                    smallestExpiry = ((CachedVBO)vboCache.get(vboCache.firstKey())).expiry + 20;
                }
            }
            return null;
        }
        if (vboCache.size() >= AngelicaConfig.itemRendererCacheSize) {
            ItemProp oldestProp = (ItemProp)vboCache.firstKey();
            vbo = (CachedVBO)vboCache.removeFirst();
            oldestProp.set(prop);
            vboCache.put((Object)oldestProp, (Object)vbo);
        } else {
            vbo = new CachedVBO();
            vboCache.put((Object)new ItemProp(prop), (Object)vbo);
        }
        vbo.expiry = ItemRenderListManager.getElapsedTicks() + 1200;
        TessellatorManager.startCapturing();
        return vbo.vertexBuffer;
    }

    public static void post(CapturingTessellator tessellator, VertexBuffer vbo) {
        List quads = TessellatorManager.stopCapturingToPooledQuads();
        int size = quads.size();
        int needed = DefaultVertexFormat.POSITION_TEXTURE_NORMAL.getVertexSize() * size << 2;
        if (quadBuffer.capacity() < needed) {
            quadBuffer = BufferUtils.createByteBuffer((int)HashCommon.nextPowerOfTwo((int)needed));
        }
        for (int i = 0; i < size; ++i) {
            DefaultVertexFormat.POSITION_TEXTURE_NORMAL.writeQuad((ModelQuadView)quads.get(i), quadBuffer);
        }
        quadBuffer.flip();
        vbo.upload(quadBuffer);
        quadBuffer.clear();
        tessellator.clearQuads();
        vbo.render();
    }

    private static int getElapsedTicks() {
        return Minecraft.getMinecraft().thePlayer.ticksExisted;
    }

    static {
        prop = new ItemProp();
    }

    private static final class ItemProp {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private int widthSubdivisions;
        private int heightSubdivisions;
        private float thickness;

        public ItemProp(ItemProp old) {
            this.set(old.minU, old.minV, old.maxU, old.maxV, old.widthSubdivisions, old.heightSubdivisions, old.thickness);
        }

        public void set(ItemProp other) {
            this.set(other.minU, other.minV, other.maxU, other.maxV, other.widthSubdivisions, other.heightSubdivisions, other.thickness);
        }

        public void set(float minU, float minV, float maxU, float maxV, int widthSubdivisions, int heightSubdivisions, float thickness) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.widthSubdivisions = widthSubdivisions;
            this.heightSubdivisions = heightSubdivisions;
            this.thickness = thickness;
        }

        @Generated
        public ItemProp() {
        }

        @Generated
        public float getMinU() {
            return this.minU;
        }

        @Generated
        public float getMinV() {
            return this.minV;
        }

        @Generated
        public float getMaxU() {
            return this.maxU;
        }

        @Generated
        public float getMaxV() {
            return this.maxV;
        }

        @Generated
        public int getWidthSubdivisions() {
            return this.widthSubdivisions;
        }

        @Generated
        public int getHeightSubdivisions() {
            return this.heightSubdivisions;
        }

        @Generated
        public float getThickness() {
            return this.thickness;
        }

        @Generated
        public void setMinU(float minU) {
            this.minU = minU;
        }

        @Generated
        public void setMinV(float minV) {
            this.minV = minV;
        }

        @Generated
        public void setMaxU(float maxU) {
            this.maxU = maxU;
        }

        @Generated
        public void setMaxV(float maxV) {
            this.maxV = maxV;
        }

        @Generated
        public void setWidthSubdivisions(int widthSubdivisions) {
            this.widthSubdivisions = widthSubdivisions;
        }

        @Generated
        public void setHeightSubdivisions(int heightSubdivisions) {
            this.heightSubdivisions = heightSubdivisions;
        }

        @Generated
        public void setThickness(float thickness) {
            this.thickness = thickness;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemProp)) {
                return false;
            }
            ItemProp other = (ItemProp)o;
            if (Float.compare(this.getMinU(), other.getMinU()) != 0) {
                return false;
            }
            if (Float.compare(this.getMinV(), other.getMinV()) != 0) {
                return false;
            }
            if (Float.compare(this.getMaxU(), other.getMaxU()) != 0) {
                return false;
            }
            if (Float.compare(this.getMaxV(), other.getMaxV()) != 0) {
                return false;
            }
            if (this.getWidthSubdivisions() != other.getWidthSubdivisions()) {
                return false;
            }
            if (this.getHeightSubdivisions() != other.getHeightSubdivisions()) {
                return false;
            }
            return Float.compare(this.getThickness(), other.getThickness()) == 0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getMinU());
            result = result * 59 + Float.floatToIntBits(this.getMinV());
            result = result * 59 + Float.floatToIntBits(this.getMaxU());
            result = result * 59 + Float.floatToIntBits(this.getMaxV());
            result = result * 59 + this.getWidthSubdivisions();
            result = result * 59 + this.getHeightSubdivisions();
            result = result * 59 + Float.floatToIntBits(this.getThickness());
            return result;
        }

        @Generated
        public String toString() {
            return "ItemRenderListManager.ItemProp(minU=" + this.getMinU() + ", minV=" + this.getMinV() + ", maxU=" + this.getMaxU() + ", maxV=" + this.getMaxV() + ", widthSubdivisions=" + this.getWidthSubdivisions() + ", heightSubdivisions=" + this.getHeightSubdivisions() + ", thickness=" + this.getThickness() + ")";
        }
    }

    private static final class CachedVBO {
        private VertexBuffer vertexBuffer = new VertexBuffer(DefaultVertexFormat.POSITION_TEXTURE_NORMAL, 7);
        private int expiry;

        private void render(int elapsedTicks) {
            this.vertexBuffer.render();
            this.expiry = elapsedTicks + 1200;
        }

        private void delete() {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

