/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.awt.image.BufferedImage;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

final class Enchantment
extends OverrideBase {
    private static final float ITEM_2D_THICKNESS = 0.0625f;
    static float baseArmorWidth;
    static float baseArmorHeight;
    private static boolean lightingWasEnabled;
    final int layer;
    final BlendMethod blendMethod;
    private final float rotation;
    private final double speed;
    final float duration;
    private boolean armorScaleSet;
    private float armorScaleX;
    private float armorScaleY;

    static void beginOuter2D() {
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
    }

    static void endOuter2D() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5888);
    }

    static void beginOuter3D() {
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)514);
        lightingWasEnabled = GL11.glGetBoolean((int)2896);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
    }

    static void endOuter3D() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        if (lightingWasEnabled) {
            GL11.glEnable((int)2896);
        }
        GL11.glMatrixMode((int)5888);
    }

    Enchantment(PropertiesFile properties) {
        super(properties);
        if (properties.valid() && this.textureName == null && this.alternateTextures == null) {
            properties.error("no source texture specified", new Object[0]);
        }
        this.layer = properties.getInt("layer", 0);
        String value = properties.getString("blend", "add");
        this.blendMethod = BlendMethod.parse(value);
        if (this.blendMethod == null) {
            properties.error("unknown blend type %s", value);
        }
        this.rotation = properties.getFloat("rotation", 0.0f);
        this.speed = properties.getDouble("speed", 0.0);
        this.duration = properties.getFloat("duration", 1.0f);
        String valueX = properties.getString("armorScaleX", "");
        String valueY = properties.getString("armorScaleY", "");
        if (!valueX.isEmpty() && !valueY.isEmpty()) {
            try {
                this.armorScaleX = Float.parseFloat(valueX);
                this.armorScaleY = Float.parseFloat(valueY);
                this.armorScaleSet = true;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    String getType() {
        return "enchantment";
    }

    void render2D(float intensity, float x0, float y0, float x1, float y1, float z) {
        if (intensity <= 0.0f) {
            return;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (!this.bindTexture(CITUtils.lastOrigIcon)) {
            return;
        }
        this.begin(intensity);
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)x0, (double)y0, (double)z, 0.0, 0.0);
        tess.addVertexWithUV((double)x0, (double)y1, (double)z, 0.0, 1.0);
        tess.addVertexWithUV((double)x1, (double)y1, (double)z, 1.0, 1.0);
        tess.addVertexWithUV((double)x1, (double)y0, (double)z, 1.0, 0.0);
        tess.draw();
        this.end();
    }

    void render3D(float intensity, int width, int height) {
        if (intensity <= 0.0f) {
            return;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        if (!this.bindTexture(CITUtils.lastOrigIcon)) {
            return;
        }
        this.begin(intensity);
        ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (int)width, (int)height, (float)0.0625f);
        this.end();
    }

    boolean bindTexture(IIcon icon) {
        ResourceLocation texture;
        if (this.alternateTextures != null && icon != null) {
            texture = (ResourceLocation)this.alternateTextures.get(icon.getIconName());
            if (texture == null) {
                texture = this.textureName;
            }
        } else {
            texture = this.textureName;
        }
        if (texture == null) {
            return false;
        }
        TexturePackAPI.bindTexture(texture);
        return true;
    }

    void beginArmor(float intensity) {
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
        this.begin(intensity);
        if (!this.armorScaleSet) {
            this.setArmorScale();
        }
        GL11.glScalef((float)this.armorScaleX, (float)this.armorScaleY, (float)1.0f);
        GL11.glMatrixMode((int)5888);
    }

    void endArmor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5890);
        this.end();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
    }

    void begin(float intensity) {
        this.blendMethod.applyBlending();
        this.blendMethod.applyDepthFunc();
        this.blendMethod.applyFade(intensity);
        GL11.glPushMatrix();
        if (this.speed != 0.0) {
            double offset = (double)System.currentTimeMillis() * this.speed / 3000.0;
            offset -= Math.floor(offset);
            GL11.glTranslatef((float)((float)offset * 8.0f), (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    void end() {
        GL11.glPopMatrix();
    }

    private void setArmorScale() {
        this.armorScaleSet = true;
        this.armorScaleX = 1.0f;
        this.armorScaleY = 0.5f;
        BufferedImage overlayImage = TexturePackAPI.getImage(this.textureName);
        if (overlayImage != null) {
            if ((float)overlayImage.getWidth() < baseArmorWidth) {
                this.armorScaleX *= baseArmorWidth / (float)overlayImage.getWidth();
            }
            if ((float)overlayImage.getHeight() < baseArmorHeight) {
                this.armorScaleY *= baseArmorHeight / (float)overlayImage.getHeight();
            }
        }
        logger.finer("%s: scaling by %.3fx%.3f for armor model", this, Float.valueOf(this.armorScaleX), Float.valueOf(this.armorScaleY));
    }
}

