/*
 * Decompiled with CFR 0.152.
 */
package jss.notfine.gui.options.control.element;

import jss.notfine.gui.options.control.element.NotFineControlElement;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class SliderControlElement
extends NotFineControlElement<Integer> {
    private final ControlValueFormatter formatter;
    private final int min;
    private final int max;
    private final int interval;
    private float value;
    private boolean mousePressed;
    private boolean dirty = false;

    public SliderControlElement(Option<Integer> option, Dim2i dim, int min, int max, int interval, ControlValueFormatter formatter) {
        super(option, dim);
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.formatter = formatter;
        this.value = option.getValue().intValue();
        this.value = MathHelper.clamp_float((float)((this.value - (float)min) / (float)(max - min)), (float)0.0f, (float)1.0f);
    }

    @Override
    public String getLabel() {
        return super.getLabel() + this.formatter.format((Integer)this.option.getValue());
    }

    public int getHoverState(boolean mouseOver) {
        return 0;
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            if (this.mousePressed) {
                this.updateSlider(mouseX);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.xPosition + (int)(this.value * (float)(this.width - 8)), this.yPosition, 0, 66, 4, 20);
            this.drawTexturedModalRect(this.xPosition + (int)(this.value * (float)(this.width - 8)) + 4, this.yPosition, 196, 66, 4, 20);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (super.mousePressed(mc, mouseX, mouseY)) {
            this.updateSlider(mouseX);
            this.mousePressed = true;
            return true;
        }
        return false;
    }

    public void mouseReleased(int mouseX, int mouseY) {
        this.mousePressed = false;
        if (this.dirty) {
            this.onOptionValueChanged();
            this.dirty = false;
        }
    }

    private void updateSlider(int mouseX) {
        this.value = (float)(mouseX - (this.xPosition + 4)) / (float)(this.width - 8);
        this.value = MathHelper.clamp_float((float)this.value, (float)0.0f, (float)1.0f);
        this.value = (float)this.min + (float)(this.max - this.min) * MathHelper.clamp_float((float)this.value, (float)0.0f, (float)1.0f);
        this.value = MathHelper.clamp_float((float)this.value, (float)this.min, (float)this.max);
        if (this.interval > 0) {
            this.value = (float)this.interval * (float)Math.round(this.value / (float)this.interval);
        }
        this.option.setValue((int)this.value);
        this.value = MathHelper.clamp_float((float)((this.value - (float)this.min) / (float)(this.max - this.min)), (float)0.0f, (float)1.0f);
        this.dirty = true;
    }
}

