/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui.options.control;

import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.element.ControlElementFactory;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import org.apache.commons.lang3.Validate;

public class SliderControl
implements Control<Integer> {
    private final Option<Integer> option;
    private final int min;
    private final int max;
    private final int interval;
    private final ControlValueFormatter mode;

    public SliderControl(Option<Integer> option, int min, int max, int interval, ControlValueFormatter mode) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0 ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) % interval == 0 ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)mode, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.mode = mode;
    }

    @Override
    public ControlElement<Integer> createElement(Dim2i dim, ControlElementFactory factory) {
        return factory.sliderControlElement(this.option, dim, this.min, this.max, this.interval, this.mode);
    }

    @Override
    public Option<Integer> getOption() {
        return this.option;
    }

    @Override
    public int getMaxWidth() {
        return 130;
    }
}

