/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.data;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizons.angelica.dynamiclights.DynamicLights;
import me.jellysquid.mods.sodium.client.util.StateUtil;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public abstract class LightDataAccess {
    public static final ThreadLocal<BlockPos> DynamicLightsPos = ThreadLocal.withInitial(BlockPos::new);
    protected WorldSlice world;

    public long get(int x, int y, int z, ModelQuadFacing d1, ModelQuadFacing d2) {
        return this.get(x + d1.getStepX() + d2.getStepX(), y + d1.getStepY() + d2.getStepY(), z + d1.getStepZ() + d2.getStepZ());
    }

    public long get(int x, int y, int z, ModelQuadFacing dir) {
        return this.get(x + dir.getStepX(), y + dir.getStepY(), z + dir.getStepZ());
    }

    public long get(BlockPos pos, ModelQuadFacing dir) {
        return this.get(pos.x, pos.y, pos.z, dir);
    }

    public long get(BlockPos pos) {
        return this.get(pos.x, pos.y, pos.getZ());
    }

    public abstract long get(int var1, int var2, int var3);

    protected long compute(int x, int y, int z) {
        boolean em;
        float ao;
        WorldSlice world = this.world;
        Block block = world.getBlock(x, y, z);
        if (block.getLightValue() == 0) {
            ao = block.getAmbientOcclusionLightValue();
            em = false;
        } else {
            ao = 1.0f;
            em = true;
        }
        boolean op = !block.isOpaqueCube() || block.getLightOpacity() == 0;
        boolean fo = block.isOpaqueCube();
        boolean fc = StateUtil.areBoundsFullCube(block);
        int lm = fo && !em ? 0 : block.getMixedBrightnessForBlock((IBlockAccess)world, x, y, z);
        return LightDataAccess.packAO(ao) | LightDataAccess.packLM(lm) | LightDataAccess.packOP(op) | LightDataAccess.packFO(fo) | LightDataAccess.packFC(fc) | 0x1000000000000000L;
    }

    public static long packOP(boolean opaque) {
        return (opaque ? 1L : 0L) << 56;
    }

    public static boolean unpackOP(long word) {
        return (word >>> 56 & 1L) != 0L;
    }

    public static long packFO(boolean opaque) {
        return (opaque ? 1L : 0L) << 57;
    }

    public static boolean unpackFO(long word) {
        return (word >>> 57 & 1L) != 0L;
    }

    public static long packFC(boolean fullCube) {
        return (fullCube ? 1L : 0L) << 58;
    }

    public static boolean unpackFC(long word) {
        return (word >>> 58 & 1L) != 0L;
    }

    public static long packLM(int lm) {
        return (long)lm & 0xFFFFFFFFL;
    }

    public static int unpackLM(long word) {
        return (int)(word & 0xFFFFFFFFL);
    }

    public static long packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return ((long)aoi & 0xFFFFL) << 32;
    }

    public static float unpackAO(long word) {
        int aoi = (int)(word >>> 32 & 0xFFFFL);
        return (float)aoi * 2.4414062E-4f;
    }

    public static int getLightMap(long originWord) {
        if (!DynamicLights.isEnabled()) {
            return LightDataAccess.unpackLM(originWord);
        }
        if (LightDataAccess.unpackFO(originWord)) {
            return LightDataAccess.unpackLM(originWord);
        }
        double dynamic = DynamicLights.get().getDynamicLightLevel(DynamicLightsPos.get());
        return DynamicLights.get().getLightmapWithDynamicLight(dynamic, LightDataAccess.unpackLM(originWord));
    }

    public WorldSlice getWorld() {
        return this.world;
    }
}

