/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.flat;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.ModelQuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import com.gtnewhorizons.angelica.config.AngelicaConfig;
import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import net.coderbot.iris.block_rendering.BlockRenderingSettings;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;

    public FlatLightPipeline(LightDataAccess lightCache) {
        this.lightCache = lightCache;
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPos pos, QuadLightData out, ModelQuadFacing cullFace, ModelQuadFacing face, boolean shade) {
        int flags;
        int lightmap = cullFace != null ? this.getOffsetLightmap(pos, cullFace) : (((flags = quad.getFlags()) & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos)) ? this.getOffsetLightmap(pos, face) : LightDataAccess.getLightMap(this.lightCache.get(pos)));
        Arrays.fill(out.lm, lightmap);
        float brightness = AngelicaConfig.enableIris && BlockRenderingSettings.INSTANCE.shouldDisableDirectionalShading() ? 1.0f : this.lightCache.getWorld().getBrightness(face, shade);
        Arrays.fill(out.br, brightness);
    }

    private int getOffsetLightmap(BlockPos pos, ModelQuadFacing face) {
        int lightmap = LightDataAccess.getLightMap(this.lightCache.get(pos, face));
        if ((lightmap & 0xF0) != 240) {
            int originLightmap = LightDataAccess.getLightMap(this.lightCache.get(pos));
            lightmap = lightmap & 0xFFFFFF00 | Math.max(lightmap & 0xFF, originLightmap & 0xFF);
        }
        return lightmap;
    }
}

