/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.gtnewhorizon.gtnhlib.client.renderer.cel.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkRenderColumn<T extends ChunkGraphicsState> {
    private final ChunkRenderContainer<T>[] renders = new ChunkRenderContainer[16];
    private final ChunkRenderColumn<T>[] adjacent = new ChunkRenderColumn[6];
    private final int x;
    private final int z;

    public ChunkRenderColumn(int x, int z) {
        this.x = x;
        this.z = z;
        this.setAdjacentColumn(ForgeDirection.UP, this);
        this.setAdjacentColumn(ForgeDirection.DOWN, this);
    }

    public void setAdjacentColumn(ForgeDirection dir, ChunkRenderColumn<T> column) {
        this.adjacent[dir.ordinal()] = column;
    }

    public ChunkRenderColumn<T> getAdjacentColumn(ForgeDirection dir) {
        return this.adjacent[dir.ordinal()];
    }

    public void setRender(int y, ChunkRenderContainer<T> render) {
        this.renders[y] = render;
    }

    public ChunkRenderContainer<T> getRender(int y) {
        if (y < 0 || y >= this.renders.length) {
            return null;
        }
        return this.renders[y];
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean areNeighborsPresent() {
        for (ModelQuadFacing dir : ModelQuadFacing.HORIZONTAL_DIRECTIONS) {
            ForgeDirection corner;
            ChunkRenderColumn<T> adj = this.adjacent[dir.ordinal()];
            if (adj == null) {
                return false;
            }
            if (dir == ModelQuadFacing.NEG_Z) {
                corner = ForgeDirection.EAST;
            } else if (dir == ModelQuadFacing.POS_Z) {
                corner = ForgeDirection.WEST;
            } else if (dir == ModelQuadFacing.NEG_X) {
                corner = ForgeDirection.NORTH;
            } else {
                if (dir != ModelQuadFacing.POS_X) continue;
                corner = ForgeDirection.SOUTH;
            }
            if (adj.getAdjacentColumn(corner) != null) continue;
            return false;
        }
        return true;
    }
}

