/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline.context;

import lombok.Generated;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.cache.ArrayLightDataCache;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.render.pipeline.ChunkRenderCache;
import me.jellysquid.mods.sodium.client.render.pipeline.FluidRenderer;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;

public class ChunkRenderCacheLocal
extends ChunkRenderCache {
    private final ArrayLightDataCache lightDataCache;
    private final BlockRenderer blockRenderer;
    private final FluidRenderer fluidRenderer;
    private final WorldSlice worldSlice;

    public ChunkRenderCacheLocal(Minecraft client, WorldClient world) {
        this.worldSlice = new WorldSlice(world);
        this.lightDataCache = new ArrayLightDataCache(this.worldSlice);
        LightPipelineProvider lightPipelineProvider = new LightPipelineProvider(this.lightDataCache);
        this.blockRenderer = new BlockRenderer(lightPipelineProvider);
        this.fluidRenderer = new FluidRenderer(lightPipelineProvider);
    }

    public void init(ChunkRenderContext context) {
        this.lightDataCache.reset(context.getOrigin());
        this.worldSlice.copyData(context);
    }

    @Generated
    public BlockRenderer getBlockRenderer() {
        return this.blockRenderer;
    }

    @Generated
    public FluidRenderer getFluidRenderer() {
        return this.fluidRenderer;
    }

    @Generated
    public WorldSlice getWorldSlice() {
        return this.worldSlice;
    }
}

